/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.ClusterDisconnectionsListener;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.HasClusterDisconnectionNotifications;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class JGroupsBusMessagingLayer
implements BusMessagingLayer,
HasClusterDisconnectionNotifications {
    public static final String DEFAULT_UDP_PROTOCOL = "jgroups:udp_ccs";
    public static final String DEFAULT_DISPATCHER = "org.lsst.ccs.messaging.util.LegacyDispatcher";
    private final Properties jgroupsProperties;
    private String xmlConfigurationFile = "udp_ccs.xml";
    private static final String propertyKeyForJGroups = "org.lsst.ccs.jgroups.";
    private static final String propertyKeyForAllBuses = "org.lsst.ccs.jgroups.ALL.";
    private static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.messaging.jgroups");
    private volatile boolean closed;
    private volatile String agentName;
    private final EnumMap<Bus, BusHandler> busHandlers = new EnumMap(Bus.class);
    private final List<ClusterDisconnectionsListener> disconnectionListeners = new CopyOnWriteArrayList<ClusterDisconnectionsListener>();
    private final Dispatcher dispatcher;

    JGroupsBusMessagingLayer(String protocolString) {
        String[] protocolInfos = protocolString.split(":");
        String rawResource = protocolInfos[1];
        if (rawResource.length() > 0) {
            this.xmlConfigurationFile = String.format("/%s.xml", rawResource);
        }
        String propertiesConfigurationFile = this.xmlConfigurationFile.replace(".xml", ".properties");
        this.jgroupsProperties = BootstrapResourceUtils.getBootstrapProperties((String)propertiesConfigurationFile, this.getClass());
        if (this.xmlConfigurationFile.toLowerCase().contains("udp") && this.jgroupsProperties.getProperty("org.lsst.ccs.jgroups.ALL.UDP.bind_interface_str") == null && this.jgroupsProperties.getProperty("org.lsst.ccs.jgroups.ALL.UDP.bind_addr") == null) {
            String en = NetworkUtilities.getMainInterfaceName();
            this.jgroupsProperties.setProperty("org.lsst.ccs.jgroups.ALL.UDP.bind_interface_str", en);
        }
        String mps = protocolInfos.length > 2 && !protocolInfos[2].trim().isEmpty() ? protocolInfos[2] : DEFAULT_DISPATCHER;
        String[] mpsPar = mps.split("\\?");
        String[] constructorParameters = mpsPar.length > 1 ? mpsPar[1].split("\\&") : new String[]{};
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(mpsPar[0]);
            this.dispatcher = (Dispatcher)clazz.getConstructor(String[].class).newInstance(new Object[]{constructorParameters});
            StringBuilder sb = new StringBuilder();
            sb.append("Message Dispatcher: ").append(this.dispatcher.getClass().getSimpleName()).append("\n");
            if (constructorParameters.length > 0) {
                sb.append("Parameters:\n");
                for (String s : constructorParameters) {
                    sb.append(s);
                }
            }
            logger.info((Object)sb.toString());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException x) {
            logger.error((Object)"Failed to initialize message Dispatcher", (Throwable)x);
            throw new RuntimeException(x);
        }
    }

    static XmlConfigurator createXmlConfiguratorForBus(String xmlConfigurationFile, Properties properties, String bus) {
        String[] propertyKeys;
        InputStream xmlConfigurationFileInputStream = BootstrapResourceUtils.getBootstrapResource((String)xmlConfigurationFile, JGroupsBusMessagingLayer.class);
        if (xmlConfigurationFileInputStream == null) {
            throw new IllegalArgumentException(xmlConfigurationFile + " not found as a resource");
        }
        XmlConfigurator configurator = null;
        try {
            configurator = XmlConfigurator.getInstance((InputStream)xmlConfigurationFileInputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create JGroups xml configuration object for " + xmlConfigurationFile, ioe);
        }
        List protocolConfigurationList = configurator.getProtocolStack();
        for (String propertyKey : propertyKeys = new String[]{propertyKeyForAllBuses, propertyKeyForJGroups + bus.toUpperCase() + "."}) {
            Set keys = BootstrapResourceUtils.getAllKeysInProperties((Properties)properties);
            for (Object key : keys) {
                String property = (String)key;
                if (!property.startsWith(propertyKey)) continue;
                String shortProperty = property.replace(propertyKey, "");
                int divider = shortProperty.lastIndexOf(".");
                String protocolPropertyName = shortProperty.substring(divider + 1);
                String protocolName = shortProperty.substring(0, divider);
                String protocolPropertyValue = properties.getProperty(property);
                boolean found = false;
                for (ProtocolConfiguration protocolConfiguration : protocolConfigurationList) {
                    if (!protocolConfiguration.getProtocolName().equals(protocolName)) continue;
                    protocolConfiguration.getProperties().put(protocolPropertyName, protocolPropertyValue);
                    found = true;
                    break;
                }
                if (found) continue;
                HashMap<String, String> hash = new HashMap<String, String>();
                hash.put(protocolPropertyName, protocolPropertyValue);
                ProtocolConfiguration newProtocol = new ProtocolConfiguration(protocolName, hash);
                protocolConfigurationList.add(newProtocol);
            }
        }
        return configurator;
    }

    public void close() throws IOException {
        this.dispatcher.shutdown();
        this.closed = true;
        for (BusHandler bh : this.busHandlers.values()) {
            bh.close();
        }
    }

    public void connect(MessagingAccessLayer accessLayer) throws DuplicateAgentNameException, IOException {
        logger.fine((Object)("### Registering " + accessLayer.getName() + " on the buses"));
        this.agentName = accessLayer.getName();
        if (this.agentName == null || "".equals(this.agentName)) {
            throw new IllegalArgumentException("Invalid agent name " + this.agentName);
        }
        this.dispatcher.initialize();
        for (MessagingAccessLayer.BusAccess ba : accessLayer.getBusAccesses()) {
            Bus bus = ba.getBus();
            try {
                XmlConfigurator configurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus(this.xmlConfigurationFile, this.jgroupsProperties, bus.toString());
                JChannel channel = new JChannel((ProtocolStackConfigurator)configurator);
                logger.debug((Object)("######################################################\nJGroup Configuration for bus: " + bus.toString() + "\n" + channel.getProtocolStack().printProtocolSpecAsXML() + "\n######################################################"));
                channel.setName(this.agentName);
                channel.connect(bus.toString());
                View view = channel.getView();
                if (this.isDuplicate(view, channel.getAddress())) {
                    channel.close();
                    throw new DuplicateAgentNameException(this.agentName, "Channel with same name already exists in view");
                }
                String[] propertiesArray = channel.getProperties().split(";");
                String bind_addr = null;
                for (int i = 0; i < propertiesArray.length; ++i) {
                    if (!propertiesArray[i].startsWith("bind_addr=")) continue;
                    bind_addr = propertiesArray[i];
                    break;
                }
                logger.debug((Object)("*** new view " + channel.getClusterName() + " " + view + " " + bind_addr));
                BusHandler bh = new BusHandler(ba, channel, view);
                this.busHandlers.put(bus, bh);
                channel.setReceiver((Receiver)bh);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.closed = false;
    }

    public void disconnect(MessagingAccessLayer accessLayers) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addClusterMembershipListener(ClusterDisconnectionsListener listener) {
        this.disconnectionListeners.add(listener);
    }

    public void removeClusterMembershipListener(ClusterDisconnectionsListener listener) {
        this.disconnectionListeners.remove(listener);
    }

    public <T extends BusMessage> void sendMessage(String senderAgent, Bus bus, T message) {
        if (this.closed) {
            throw new TransportStateException("JGroups layer not connected");
        }
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        this.busHandlers.get(bus).send(message);
    }

    public Set<String> getRegisteredLocalAgents(Bus ... buses) {
        return this.agentName == null ? Collections.emptySet() : Collections.singleton(this.agentName);
    }

    private boolean isDuplicate(View view, Address address) {
        for (Address a : view.getMembers()) {
            if (address.equals(a) || !a.toString().equals(address.toString())) continue;
            return true;
        }
        return false;
    }

    public void register(String agentName, Bus ... buses) throws IOException, DuplicateAgentNameException {
    }

    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        throw new UnsupportedOperationException("BusMessagingLayer called");
    }

    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        throw new UnsupportedOperationException("BusMessagingLayer called");
    }

    public void closeFor(String agentName, Bus ... buses) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class BusHandler
    extends ReceiverAdapter {
        private final JChannel channel;
        private final MessagingAccessLayer.BusAccess accessLayer;
        private View lastView;

        BusHandler(MessagingAccessLayer.BusAccess accessLayer, JChannel chan, View view) {
            this.accessLayer = accessLayer;
            this.channel = chan;
            this.lastView = view;
        }

        public void receive(final Message message) {
            Dispatcher.Task task = new Dispatcher.Task(){
                private volatile CCSTimeStamp toQueue;
                private volatile CCSTimeStamp fromQueue;

                public void stageEnded(Dispatcher.Stage ... stages) {
                    block4: for (Dispatcher.Stage stage : stages) {
                        switch (stage) {
                            case START: {
                                this.toQueue = CCSTimeStamp.currentTime();
                                continue block4;
                            }
                            case WAIT: {
                                this.fromQueue = CCSTimeStamp.currentTime();
                            }
                        }
                    }
                }

                public void run() {
                    BusMessage busMessInit;
                    try {
                        busMessInit = (BusMessage)message.getObject();
                        busMessInit.setIncomingQueueInTimeStamp(this.toQueue);
                        busMessInit.setIncomingQueueOutTimeStamp(this.fromQueue);
                    }
                    catch (RuntimeException exc) {
                        BusHandler.this.accessLayer.processClusterDeserializationError(message.getSrc().toString(), exc);
                        return;
                    }
                    BusMessage busMess = busMessInit;
                    BusHandler.this.accessLayer.processBusMessage(busMess);
                }
            };
            JGroupsBusMessagingLayer.this.dispatcher.in((Runnable)task, this.getBus(), new String[]{message.getSrc().toString()});
        }

        public void viewAccepted(View view) {
            logger.fine((Object)("view accepted : " + view.getMembers()));
            Address[][] diffArray = View.diff((View)this.lastView, (View)view);
            this.lastView = view;
            if (this.getBus() == Bus.STATUS) {
                ArrayList<String> disconnectedAgents = new ArrayList<String>();
                for (Address address : diffArray[1]) {
                    disconnectedAgents.add(address.toString());
                }
                logger.fine((Object)("Firing notification of cluster disconnection: ====== " + disconnectedAgents));
                JGroupsBusMessagingLayer.this.dispatcher.in(() -> {
                    for (ClusterDisconnectionsListener l : JGroupsBusMessagingLayer.this.disconnectionListeners) {
                        try {
                            l.membersLeft((List)disconnectedAgents);
                        }
                        catch (Exception x) {
                            logger.warn((Object)"Exception while notifying listeners of agent disconnection", (Throwable)x);
                        }
                    }
                }, this.getBus(), disconnectedAgents.toArray(new String[0]));
            }
            logger.fine((Object)("Updated current view : " + this.lastView.getMembers()));
        }

        void close() {
            this.channel.close();
        }

        void send(final BusMessage message) {
            Dispatcher.Task task = new Dispatcher.Task(){

                public void stageEnded(Dispatcher.Stage ... stages) {
                    block4: for (Dispatcher.Stage stage : stages) {
                        switch (stage) {
                            case START: {
                                message.setOutgoingQueueInTimeStamp(CCSTimeStamp.currentTime());
                                continue block4;
                            }
                            case WAIT: {
                                message.setOutgoingQueueOutTimeStamp(CCSTimeStamp.currentTime());
                            }
                        }
                    }
                }

                public void run() {
                    try {
                        BusHandler.this.channel.send(null, (Object)message);
                    }
                    catch (Exception exc) {
                        throw new RuntimeException(exc);
                    }
                }
            };
            JGroupsBusMessagingLayer.this.dispatcher.out((Runnable)task, this.getBus(), Dispatcher.Order.NORM);
        }

        Bus getBus() {
            return this.accessLayer.getBus();
        }
    }
}

