/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.io.IOException;
import java.io.Serializable;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.TransportManager;

public class TestJGroupsMultipleConnections {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testMultipleConnections() throws Exception {
    }

    private class ConnectToJGroupsBuses
    implements Runnable {
        private final BusMessagingLayer layer;
        private final String name;

        ConnectToJGroupsBuses(String name) throws Exception {
            this(name, TransportManager.getConnection((String)"jgroups:udp_ccs", null));
        }

        ConnectToJGroupsBuses(String name, BusMessagingLayer layer) throws Exception {
            this.name = name;
            this.layer = layer;
        }

        @Override
        public void run() {
            try {
                this.layer.register(this.name, new Bus[]{Bus.COMMAND, Bus.LOG, Bus.STATUS});
                this.layer.sendMessage(this.name, Bus.STATUS, (BusMessage)new StatusSubsystemData(new KeyValueData("testMessage", (Serializable)((Object)"testMessage"))));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        BusMessagingLayer getLayer() {
            return this.layer;
        }

        String getName() {
            return this.name;
        }
    }

    private class WaitSomeSeconds
    implements Runnable {
        private final long wait;

        WaitSomeSeconds(long wait) {
            this.wait = wait;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.wait);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

