package org.lsst.ccs.messaging.jgroups;

import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.stack.GossipRouter;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;

/**
 *
 * @author The LSST CCS Team
 */
class BusGossipRouter implements Runnable {

    private final GossipRouter router;
    private final int port;
    private final String routerHost, busName;

    private final int backlog=0;
    private final long soLinger=-1;
    private final long soTimeout=-1;
    private final long expiry_time=60000;

    private final boolean jmx=false, nio=true, suspects=true;

    BusGossipRouter(Bus bus) {        
        routerHost = getRouterProperties().getProperty("org.lsst.ccs.router.host", "");
        if ( routerHost.isEmpty() ) {
            throw new RuntimeException("The Gossip Router Host must be provided via property \"org.lsst.ccs.router.host\"");
        }

        String routerPortStr = getRouterProperties().getProperty("org.lsst.ccs.router.port", "12000");
        int routerPort = Integer.parseInt(routerPortStr);
        port = routerPort+bus.ordinal()*10;
        this.router = new GossipRouter(routerHost, port)
          .jmx(jmx).expiryTime(expiry_time)
          .useNio(nio)
          .backlog(backlog)
          .socketReadTimeout(soTimeout)
          .lingerTimeout(soLinger)
          .emitSuspectEvents(suspects);
                
        busName = bus.toString();
    }

    int getPort() {
        return port;
    }
    
    String getHost() {
        return routerHost;
    }
        
    Address getAddress() {
        return router.localAddress();
    }
                
    @Override
    public void run() {
        try {
            System.out.println("\nStarting gossip router for "+busName+" bus on port "+port);
            router.start();
        } catch (Exception e) {
            throw new RuntimeException("Failed to start Gossip Router ", e);
        }
    }

    boolean isStarted() {
        return router.running();
    }

    private static Properties routerProperties;
    static Properties getRouterProperties() {
        if ( routerProperties == null ) {
            routerProperties = BootstrapResourceUtils.getBootstrapProperties("GossipRouter.properties");
        }
        return routerProperties;
    }
    
}
