package org.lsst.ccs.messaging.jgroups;

import org.jgroups.stack.IpAddress;
import org.lsst.ccs.bus.definition.Bus;

/**
 *
 * @author The LSST CCS Team
 */
public class JGroupsCCSGossipRouter {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {

        Bus[] buses = Bus.values();
        for (Bus b : buses) {
            BusGossipRouter router = new BusGossipRouter(b);
            Thread t = new Thread(router);
            t.start();
            while (!router.isStarted()) {
                Thread.sleep(100l);
            }

            IpAddress local=(IpAddress)router.getAddress();
            System.out.printf("\nGossipRouter %s listening on %s:%s\n", b.name(), local.getIpAddress(),  local.getPort());
        }

    }

}
