package org.lsst.ccs.messaging.jgroups;

import java.util.Properties;
import org.jgroups.stack.GossipRouter;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;

/**
 *
 * @author The LSST CCS Team
 */
class BusGossipRouter implements Runnable {

    private final GossipRouter router;
    private final int port;
    private final String routerHost, busName;

    BusGossipRouter(Bus bus) {        
        routerHost = getRouterProperties().getProperty("org.lsst.ccs.router.host", "");
        if ( routerHost.isEmpty() ) {
            throw new RuntimeException("The Gossip Router Host must be provided via property \"org.lsst.ccs.router.host\"");
        }

        String routerPortStr = getRouterProperties().getProperty("org.lsst.ccs.router.port", "12000");
        int routerPort = Integer.parseInt(routerPortStr);
        port = routerPort+bus.ordinal()*10;
        this.router = new GossipRouter(port, routerHost);
        busName = bus.toString();
    }

    int getPort() {
        return port;
    }
    
    String getHost() {
        return routerHost;
    }
        
    @Override
    public void run() {
        try {
            System.out.println("\nStarting gossip router for "+busName+" bus on port "+port);
            router.start();
        } catch (Exception e) {
            throw new RuntimeException("Failed to start Gossip Router ", e);
        }
    }

    boolean isStarted() {
        return router.isStarted();
    }

    private static Properties routerProperties;
    static Properties getRouterProperties() {
        if ( routerProperties == null ) {
            routerProperties = BootstrapResourceUtils.getBootstrapProperties("GossipRouter.properties");
        }
        return routerProperties;
    }
    
}
