package org.lsst.ccs.messaging.jgroups;

import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.TransportManager;


/**
 */
public class JGroupsTransportManager extends TransportManager {

    @Override
    public BusMessagingLayer getInstance(String protocolString, String propertiesString) {

        if (protocolString.startsWith("jgroups")) {
            if ("jgroups".equals(protocolString)) {
                protocolString = JGroupsBusMessagingLayer.DEFAULT_UDP_PROTOCOL;
            }
            JGroupsBusMessagingLayer layer = new JGroupsBusMessagingLayer(protocolString);
            return layer;
        } else {
            return null;
        }
    }

    String getKey(String protocolString, String propertiesString) {
        //just in case
        String props = propertiesString.replace('\n', ';');
        return props.replaceAll("\\s", "");
    }
}
