/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.messaging.ProvidesDisconnectionInformation;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.jgroups.BusGossipRouter;
import org.lsst.ccs.messaging.jgroups.DisconnectedAgent;
import org.lsst.ccs.messaging.jgroups.TunnelMessage;
import org.lsst.ccs.utilities.logging.Logger;

public class JGroupsBusMessagingLayer
implements BusMessagingLayer,
ProvidesDisconnectionInformation {
    public static final String DEFAULT_UDP_PROTOCOL = "jgroups:udp_ccs";
    private final Properties jgroupsProperties;
    private String xmlConfigurationFile = "udp_ccs.xml";
    private static final String propertyKeyForJGroups = "org.lsst.ccs.jgroups.";
    private static final String propertyKeyForAllBuses = "org.lsst.ccs.jgroups.ALL.";
    private static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.messaging.jgroups");
    private final LocalAgentChannels localAgentChannels = new LocalAgentChannels();
    private final View[] lastViews = new View[Bus.values().length];
    private volatile boolean closed;

    private void sendObjectInTunnelMessageOnChannel(Object obj, JChannel channel) {
        try {
            TunnelMessage msg = new TunnelMessage(obj);
            channel.send((Message)msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    JGroupsBusMessagingLayer(String protocolString) {
        String[] protocolInfos = protocolString.split(":");
        String rawResource = protocolInfos[1];
        if (rawResource.length() > 0) {
            this.xmlConfigurationFile = String.format("/%s.xml", rawResource);
        }
        String propertiesConfigurationFile = this.xmlConfigurationFile.replace(".xml", ".properties");
        this.jgroupsProperties = BootstrapResourceUtils.getBootstrapProperties((String)propertiesConfigurationFile, this.getClass());
        if (this.jgroupsProperties.getProperty("org.lsst.ccs.jgroups.ALL.UDP.bind_interface_str") == null && this.jgroupsProperties.getProperty("org.lsst.ccs.jgroups.ALL.UDP.bind_addr") == null) {
            String en = NetworkUtilities.getMainInterfaceName();
            this.jgroupsProperties.setProperty("org.lsst.ccs.jgroups.ALL.UDP.bind_interface_str", en);
        }
    }

    public void register(String agentName, Bus ... buses) throws IOException, DuplicateAgentNameException {
    }

    public Set<String> getRegisteredLocalAgents(Bus ... buses) {
        if (buses == null || buses.length == 0) {
            buses = Bus.values();
        }
        HashSet<String> result = new HashSet<String>();
        for (Bus bus : buses) {
            BusReceiver receiver = this.localAgentChannels.receivers[bus.ordinal()];
            if (receiver == null || result.contains(this.localAgentChannels.agentName)) continue;
            result.add(this.localAgentChannels.agentName);
        }
        return result;
    }

    static XmlConfigurator createXmlConfiguratorForBus(String xmlConfigurationFile, Properties properties, String bus) {
        String[] propertyKeys;
        InputStream xmlConfigurationFileInputStream = BootstrapResourceUtils.getBootstrapResource((String)xmlConfigurationFile, JGroupsBusMessagingLayer.class);
        if (xmlConfigurationFileInputStream == null) {
            throw new IllegalArgumentException(xmlConfigurationFile + " not found as a resource");
        }
        XmlConfigurator configurator = null;
        try {
            configurator = XmlConfigurator.getInstance((InputStream)xmlConfigurationFileInputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create JGroups xml configuration object for " + xmlConfigurationFile, ioe);
        }
        List protocolConfigurationList = configurator.getProtocolStack();
        for (String propertyKey : propertyKeys = new String[]{propertyKeyForAllBuses, propertyKeyForJGroups + bus.toUpperCase() + "."}) {
            Set keys = BootstrapResourceUtils.getAllKeysInProperties((Properties)properties);
            for (Object key : keys) {
                String property = (String)key;
                if (!property.startsWith(propertyKey)) continue;
                String shortProperty = property.replace(propertyKey, "");
                int divider = shortProperty.lastIndexOf(".");
                String protocolPropertyName = shortProperty.substring(divider + 1);
                String protocolName = shortProperty.substring(0, divider);
                String protocolPropertyValue = properties.getProperty(property);
                boolean found = false;
                for (ProtocolConfiguration protocolConfiguration : protocolConfigurationList) {
                    if (!protocolConfiguration.getProtocolName().equals(protocolName)) continue;
                    protocolConfiguration.getProperties().put(protocolPropertyName, protocolPropertyValue);
                    found = true;
                    break;
                }
                if (found) continue;
                HashMap<String, String> hash = new HashMap<String, String>();
                hash.put(protocolPropertyName, protocolPropertyValue);
                ProtocolConfiguration newProtocol = new ProtocolConfiguration(protocolName, hash);
                protocolConfigurationList.add(newProtocol);
            }
        }
        return configurator;
    }

    private boolean isDuplicate(View view, Address address) {
        for (Address a : view.getMembers()) {
            if (address.equals(a) || !a.toString().equals(address.toString())) continue;
            return true;
        }
        return false;
    }

    public void closeFor(String agentName, Bus ... buses) {
        if (agentName == null || "".equals(agentName)) {
            throw new IllegalArgumentException("Agent name cannot be null or empty");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if (this.localAgentChannels != null) {
            for (Bus bus : buses) {
                int index = bus.ordinal();
                JChannel channel = this.localAgentChannels.channels[index];
                if (channel == null) continue;
                channel.close();
            }
        }
    }

    public void close() throws IOException {
        this.closed = true;
        for (JChannel channel : this.localAgentChannels.channels) {
            if (channel == null) continue;
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BusMessage> void sendMessage(String senderAgent, Bus bus, T message) {
        if (this.closed) {
            throw new TransportStateException("closing");
        }
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        int index = bus.ordinal();
        JChannel channel = this.localAgentChannels.channels[index];
        if (channel == null) {
            throw new IllegalArgumentException("agent " + senderAgent + " not registered on " + bus);
        }
        try {
            JChannel jChannel = channel;
            synchronized (jChannel) {
                channel.send(null, message);
            }
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (agentName == null || "".equals(agentName)) {
            throw new IllegalArgumentException("Invalid name for an agent. It cannot be empty or null.");
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if (this.localAgentChannels == null) {
            throw new IllegalArgumentException(" agent " + agentName + " not registered");
        }
        for (Bus bus : buses) {
            BusReceiver receiver = this.localAgentChannels.receivers[bus.ordinal()];
            if (receiver != null) continue;
            throw new IllegalArgumentException(" agent " + agentName + " not registered on bus " + bus);
        }
    }

    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (agentName == null || "".equals(agentName)) {
            throw new IllegalArgumentException("Invalid name for an agent. It cannot be empty or null.");
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if (this.localAgentChannels == null) {
            return;
        }
        for (Bus bus : buses) {
            BusReceiver receiver = this.localAgentChannels.receivers[bus.ordinal()];
            if (receiver != null) continue;
        }
    }

    public void connect(MessagingAccessLayer accessLayer) throws DuplicateAgentNameException, IOException {
        StringBuilder allBuses = new StringBuilder();
        for (MessagingAccessLayer.BusAccess ba : accessLayer.getBusAccesses()) {
            allBuses.append(ba.getBus() + " ");
        }
        logger.fine((Object)("### Registering " + accessLayer.getName() + " for buses " + allBuses));
        if (this.closed) {
            throw new TransportStateException("closing");
        }
        String agentName = accessLayer.getName();
        if (agentName == null || "".equals(agentName)) {
            throw new IllegalArgumentException("Invalid agent name " + agentName);
        }
        for (MessagingAccessLayer.BusAccess ba : accessLayer.getBusAccesses()) {
            Bus bus = ba.getBus();
            int index = ba.getBus().ordinal();
            try {
                String tunnelConfigurationFileStup = "tunnel_ccs";
                Properties tunnelProperties = BootstrapResourceUtils.getBootstrapProperties((String)(tunnelConfigurationFileStup + ".properties"), this.getClass());
                String tunnelProperty = tunnelProperties.getProperty("org.lsst.ccs.tunnel", "");
                JChannel tunnelChannel = null;
                JChannel busChannel = null;
                if (tunnelProperty.isEmpty() || tunnelProperty.equals("server")) {
                    XmlConfigurator configurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus(this.xmlConfigurationFile, this.jgroupsProperties, bus.toString());
                    JChannel channel = new JChannel((ProtocolStackConfigurator)configurator);
                    logger.debug((Object)("######################################################\nJGroup Configuration for bus: " + bus.toString() + "\n" + channel.getProtocolStack().printProtocolSpecAsXML() + "\n######################################################"));
                    channel.setName(agentName);
                    channel.connect(bus.toString());
                    if (this.isDuplicate(channel.getView(), channel.getAddress())) {
                        channel.close();
                        throw new DuplicateAgentNameException(agentName, "Channel with same name already exists in view");
                    }
                    this.lastViews[index] = channel.getView();
                    String[] propertiesArray = channel.getProperties().split(";");
                    String bind_addr = null;
                    for (int i = 0; i < propertiesArray.length; ++i) {
                        if (!propertiesArray[i].startsWith("bind_addr=")) continue;
                        bind_addr = propertiesArray[i];
                        break;
                    }
                    logger.debug((Object)("*** new view " + channel.getClusterName() + " " + channel.getView() + " " + bind_addr));
                    busChannel = channel;
                }
                if (!tunnelProperty.isEmpty()) {
                    boolean isServer = tunnelProperty.equals("server");
                    try {
                        String startRouter;
                        String tunnelPort = tunnelProperties.getProperty("org.lsst.ccs.tunnel.port", "7800");
                        int port = Integer.parseInt(tunnelPort) + 10 * bus.ordinal();
                        BusGossipRouter router = new BusGossipRouter(bus);
                        if (isServer && (startRouter = tunnelProperties.getProperty("org.lsst.ccs.tunnel.start.router", "false")).equals("true")) {
                            Thread t = new Thread(router);
                            t.start();
                        }
                        if (tunnelProperties.getProperty(propertyKeyForJGroups + bus + "_TUNNEL.TCPGOSSIP.initial_hosts", "").isEmpty()) {
                            tunnelProperties.setProperty(propertyKeyForJGroups + bus + "_TUNNEL.TCPGOSSIP.initial_hosts", router.getHost() + "[" + router.getPort() + "]");
                        }
                        if (tunnelProperties.getProperty(propertyKeyForJGroups + bus + "_TUNNEL.TCP.bind_port", "").isEmpty()) {
                            tunnelProperties.setProperty(propertyKeyForJGroups + bus + "_TUNNEL.TCP.bind_port", String.valueOf(port));
                        }
                        XmlConfigurator tunnelConfigurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus(tunnelConfigurationFileStup + ".xml", tunnelProperties, bus + "_TUNNEL");
                        tunnelChannel = new JChannel((ProtocolStackConfigurator)tunnelConfigurator);
                        logger.debug((Object)("######################################################\nJGroup Configuration for bus: " + bus + "_TUNNEL \n" + tunnelChannel.getProtocolStack().printProtocolSpecAsXML() + "\n######################################################"));
                        tunnelChannel.setName(agentName);
                        tunnelChannel.connect(bus + "_TUNNEL");
                        this.lastViews[index] = tunnelChannel.getView();
                        if (isServer) {
                            tunnelChannel.setReceiver((Receiver)new TunnelReceiver(busChannel, agentName));
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                if (busChannel == null) {
                    busChannel = tunnelChannel;
                    tunnelChannel = null;
                }
                this.localAgentChannels.agentName = agentName;
                this.localAgentChannels.channels[bus.ordinal()] = busChannel;
                this.localAgentChannels.receivers[index] = new BusReceiver(ba, busChannel, this, tunnelChannel);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void disconnect(MessagingAccessLayer accessLayers) {
        Bus[] buses = new Bus[accessLayers.getBusAccesses().size()];
        for (MessagingAccessLayer.BusAccess layer : accessLayers.getBusAccesses()) {
            buses[layer.getBus().ordinal()] = layer.getBus();
        }
        this.closeFor(accessLayers.getName(), buses);
    }

    class BusReceiver
    extends ReceiverAdapter {
        JChannel curChan;
        BusMessagingLayer layer;
        MessagingAccessLayer.BusAccess accessLayer;
        private final JChannel tunnel;

        BusReceiver(MessagingAccessLayer.BusAccess accessLayer, JChannel curChan, BusMessagingLayer layer, JChannel tunnel) {
            this.accessLayer = accessLayer;
            this.curChan = curChan;
            curChan.setReceiver((Receiver)this);
            this.layer = layer;
            this.tunnel = tunnel;
        }

        public void receive(Message message) {
            BusMessage busMessInit;
            try {
                Object obj = message.getObject();
                if (obj instanceof DisconnectedAgent) {
                    String agent = ((DisconnectedAgent)obj).getAgentName();
                    ((MessagingAccessLayer.StatusBusAccess)this.accessLayer).processDisconnectionSuspicion(agent);
                    return;
                }
                busMessInit = (BusMessage)message.getObject();
            }
            catch (RuntimeException exc) {
                this.accessLayer.processClusterDeserializationError(message.getSrc().toString());
                logger.warn((Object)"cluster deserialization exception", (Throwable)exc);
                return;
            }
            BusMessage busMess = busMessInit;
            this.accessLayer.processBusMessage(busMess);
            if (this.tunnel != null && !message.getSrc().toString().equals(this.tunnel.getAddressAsString())) {
                JGroupsBusMessagingLayer.this.sendObjectInTunnelMessageOnChannel(message.getObject(), this.tunnel);
            }
        }

        private void processDisconnection(Address a) {
            ((MessagingAccessLayer.StatusBusAccess)this.accessLayer).processDisconnectionSuspicion(a.toString());
            if (this.tunnel != null) {
                JGroupsBusMessagingLayer.this.sendObjectInTunnelMessageOnChannel(new DisconnectedAgent(a.toString()), this.tunnel);
            }
            logger.fine((Object)("removing ====== " + a));
        }

        public void viewAccepted(View view) {
            logger.fine((Object)("view accepted : " + view.getMembers()));
            int index = this.accessLayer.getBus().ordinal();
            View lastView = JGroupsBusMessagingLayer.this.lastViews[index];
            Address[][] diffArray = View.diff((View)lastView, (View)view);
            ((JGroupsBusMessagingLayer)JGroupsBusMessagingLayer.this).lastViews[index] = view;
            if (index == Bus.STATUS.ordinal()) {
                for (Address address : diffArray[1]) {
                    this.processDisconnection(address);
                }
            }
            logger.fine((Object)("Updated current view : " + JGroupsBusMessagingLayer.this.lastViews[this.accessLayer.getBus().ordinal()].getMembers()));
        }

        public void suspect(Address address) {
            logger.fine((Object)("disconnection suspicion on " + this.accessLayer.getBus() + " bus : " + address.toString()));
            int index = this.accessLayer.getBus().ordinal();
            if (index == Bus.STATUS.ordinal()) {
                this.processDisconnection(address);
            }
        }
    }

    class TunnelReceiver
    extends ReceiverAdapter {
        private final String agentName;
        private final JChannel channel;

        TunnelReceiver(JChannel channel, String agentName) {
            this.channel = channel;
            this.agentName = agentName;
        }

        public void receive(Message message) {
            if (message.getSrc().toString().equals(this.agentName)) {
                return;
            }
            JGroupsBusMessagingLayer.this.sendObjectInTunnelMessageOnChannel(message.getObject(), this.channel);
        }
    }

    class LocalAgentChannels {
        String agentName;
        JChannel[] channels = new JChannel[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];

        LocalAgentChannels() {
        }
    }
}

