/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.util.Random;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.lsst.ccs.bus.jgroups.GroupTopic;
import org.lsst.ccs.messaging.jgroups.CommandThing;
import org.lsst.ccs.messaging.jgroups.ReplyThing;

public class Factory {
    private ReceiverAdapter receiverCommands;
    private ReceiverAdapter receiverStatus;
    private ReceiverAdapter receiverLog;
    private GroupTopic commandTopic;
    private GroupTopic statusTopic;
    private GroupTopic logTopic;

    public Factory() {
        try {
            this.commandTopic = GroupTopic.create((String)"command", (String)"UDP(mcast_port=26969)");
            this.statusTopic = GroupTopic.create((String)"status", (String)"UDP(mcast_port=36969)");
            this.logTopic = GroupTopic.create((String)"log", (String)"UDP(mcast_port=46969)");
            this.initListenToCommand();
            this.initListenToStatus();
        }
        catch (Exception e) {
            throw new Error("group communication cannot start: " + e);
        }
    }

    synchronized void initListenToCommand() {
        if (this.commandTopic.getAdapter() == null) {
            this.receiverCommands = new ReceiverAdapter(){

                public void receive(Message msg) {
                    try {
                        Object payload = msg.getObject();
                        if (payload instanceof CommandThing) {
                            CommandThing command = (CommandThing)payload;
                            System.out.println("####receiving command: " + command);
                        } else if (payload instanceof ReplyThing) {
                            System.out.println("####receiving reply: " + payload);
                        }
                    }
                    catch (Exception exception) {}
                }
            };
            this.commandTopic.setAdapter(this.receiverCommands);
        }
    }

    synchronized void initListenToStatus() {
        if (this.statusTopic.getAdapter() == null) {
            this.receiverStatus = new ReceiverAdapter(){

                public void receive(Message msg) {
                    try {
                        Object payload = msg.getObject();
                        System.out.println("####receiving status: " + payload);
                    }
                    catch (Exception exception) {}
                }
            };
            this.statusTopic.setAdapter(this.receiverStatus);
        }
    }

    public void reply(ReplyThing cmd) {
        System.out.println("#### sending reply ");
        try {
            this.commandTopic.sendMessage((Object)cmd);
        }
        catch (Exception exception) {}
    }

    public static void main(String[] args) throws Exception {
        Factory fact = new Factory();
        int id = new Random().nextInt(1000);
        int ix = 0;
        while (ix < 5) {
            fact.statusTopic.sendMessage((Object)"status");
            fact.reply(new ReplyThing(id, ix, new CommandThing()));
            Thread.sleep(5000L);
            ++ix;
        }
        GroupTopic.closeAll();
    }
}

