package org.lsst.ccs.bus.jgroups;

import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.TransportManager;

import java.util.HashMap;

/**
 */
public class JGroupsTransportManager extends TransportManager {

    static final HashMap<String, JGroupsBusMessagingLayer> map = new HashMap<String, JGroupsBusMessagingLayer>() ;
    @Override
    public BusMessagingLayer getInstance(String protocolString, String propertiesString) {

        if(protocolString.startsWith("jgroups")) {
            if("jgroups".equals(protocolString)) {
                protocolString = JGroupsBusMessagingLayer.DEFAULT_UDP_PROTOCOL ;
            }
            JGroupsBusMessagingLayer res = map.get(protocolString) ;
            if(res == null) {
                 JGroupsBusMessagingLayer layer = new JGroupsBusMessagingLayer(protocolString)  ;
                map.put(protocolString, layer) ;
                return layer ;
            } else {
                return res ;
            }

        } else {
            return null ;
        }
    }
    
     String getKey(String protocolString, String propertiesString) {
        //just in case
        String props = propertiesString.replace('\n', ';') ;
        return props.replaceAll("\\s", "") ;
    }
}
