/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jgroups;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.UUID;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.BusMessageForwarder;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.BusPayload;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.DestinationsException;
import org.lsst.ccs.bus.DuplicateBusNameException;
import org.lsst.ccs.bus.TransportStateException;

public class JGroupsBusMessagingLayer
implements BusMessagingLayer {
    public static final String DEFAULT_UDP_PROTOCOL = "jgroups:udp_ccs:";
    public static final String DEFAULT_UDP_PROPERTIES = "LOG:udp.mcast_port=26969;STATUS:udp.mcast_port=36969;COMMAND:udp.mcast_port=46969;";
    public static final String DEFAULT_TCP_PROTOCOL = "jgroups:tcp_ccs:";
    public static final String DEFAULT_TCP_PROPERTIES = "jgroups.bind_addr=localhost;lsst.groups.trybroadcast=true; ";
    URL protocolURL = JGroupsBusMessagingLayer.class.getResource("/udp_ccs.xml");
    String protocolInfo;
    String[] portDesc = new String[]{"26969", "36969", "46969"};
    Properties properties = new Properties();
    boolean tryBroadcast;
    static Logger logger = Logger.getLogger((String)"lsst.ccs.groups");
    CopyOnWriteArrayList<AgentAdresses> otherAddresses = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<AgentAdresses> anonymousAddresses = new CopyOnWriteArrayList();
    Map<String, LocalAgentChannels> mapLocalChannels = new ConcurrentHashMap<String, LocalAgentChannels>();
    BusMembershipListener[] membershipListeners = new BusMembershipListener[Bus.values().length];
    View[] lastViews = new View[Bus.values().length];
    volatile boolean closed;

    @Deprecated
    public JGroupsBusMessagingLayer() {
        this(DEFAULT_UDP_PROTOCOL, DEFAULT_UDP_PROPERTIES);
    }

    JGroupsBusMessagingLayer(String protocolString, String propertiesString) {
        String[] protocolInfos = protocolString.split(":");
        String rawResource = protocolInfos[1];
        if (rawResource.length() > 0) {
            String resourceName = String.format("/%s.xml", rawResource);
            this.protocolURL = JGroupsBusMessagingLayer.class.getResource(resourceName);
            if (this.protocolURL == null) {
                throw new IllegalArgumentException(String.valueOf(resourceName) + " not found as a resource");
            }
        } else {
            this.protocolInfo = protocolInfos[2];
        }
        StringReader reader = new StringReader(propertiesString.replace(';', '\n'));
        try {
            this.properties.load(reader);
            Properties systemProperties = System.getProperties();
            systemProperties.putAll((Map<?, ?>)this.properties);
            this.tryBroadcast = Boolean.getBoolean("lsst.groups.trybroadcast");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("properties syntax? " + propertiesString);
        }
    }

    public void register(String agentName, Bus ... buses) throws IOException {
        int n;
        if (this.closed) {
            throw new TransportStateException("closing");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        } else {
            for (AgentAdresses adresses : this.otherAddresses) {
                if (!agentName.equals(adresses.agentName)) continue;
                Bus[] busArray = buses;
                int n2 = buses.length;
                n = 0;
                while (n < n2) {
                    Bus bus = busArray[n];
                    if (adresses.busAdresses[bus.ordinal()] != null) {
                        DuplicateBusNameException exception = new DuplicateBusNameException(agentName, " already registered on " + bus);
                        BusMembershipListener listener = this.membershipListeners[bus.ordinal()];
                        if (listener != null) {
                            listener.anormalEvent((Exception)exception);
                        }
                    }
                    ++n;
                }
            }
        }
        LocalAgentChannels localChannels = this.mapLocalChannels.get(agentName);
        if (localChannels == null) {
            localChannels = new LocalAgentChannels();
            localChannels.agentName = agentName;
            this.mapLocalChannels.put(agentName, localChannels);
        }
        Bus[] busArray = buses;
        n = buses.length;
        int n3 = 0;
        while (n3 < n) {
            Bus bus = busArray[n3];
            int index = bus.ordinal();
            JChannel channel = localChannels.channels[index];
            if (channel == null || !channel.isConnected()) {
                try {
                    String propValueString = this.properties.getProperty(bus.toString());
                    if (propValueString != null) {
                        String[] keyVal = propValueString.split("=");
                        System.setProperty("jgroups." + keyVal[0], keyVal[1]);
                    }
                    channel = this.protocolInfo == null ? new JChannel(this.protocolURL) : new JChannel(this.protocolInfo);
                    localChannels.channels[index] = channel;
                    channel.setName(agentName);
                    channel.connect(bus.toString());
                    View view = channel.getView();
                    this.updateMapAdressesFromView(bus, channel, view);
                    localChannels.receivers[index] = new BusReceiver(agentName, bus, channel);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            ++n3;
        }
    }

    private synchronized void updateMapAdressesFromView(Bus bus, JChannel channel, View view) {
        ArrayList modifiedMembers;
        boolean adding;
        int index = bus.ordinal();
        ArrayList newMembers = view.getMembers();
        View lastView = this.lastViews[index];
        if (lastView == null) {
            adding = true;
            modifiedMembers = newMembers;
        } else {
            List oldMembers = lastView.getMembers();
            adding = newMembers.containsAll(oldMembers);
            if (adding) {
                modifiedMembers = new ArrayList(newMembers);
                modifiedMembers.removeAll(oldMembers);
            } else {
                modifiedMembers = new ArrayList(oldMembers);
                modifiedMembers.removeAll(newMembers);
            }
        }
        this.lastViews[index] = view;
        if (adding) {
            for (Address address : modifiedMembers) {
                BusMembershipListener listener;
                String name = address.toString();
                if ("__".equals(name)) {
                    AgentAdresses agentAdresses = new AgentAdresses();
                    agentAdresses.agentName = "__";
                    agentAdresses.busAdresses[index] = address;
                    this.anonymousAddresses.add(agentAdresses);
                    logger.info((Object)("adding ====== " + address + " to " + bus));
                    continue;
                }
                boolean found = false;
                for (AgentAdresses agentAdresses : this.otherAddresses) {
                    if (!agentAdresses.agentName.equals(name)) continue;
                    agentAdresses.busAdresses[index] = address;
                    logger.info((Object)("adding ====== " + address + " to " + bus));
                    found = true;
                    break;
                }
                if (!found) {
                    AgentAdresses agentAdresses;
                    agentAdresses = new AgentAdresses();
                    agentAdresses.agentName = name;
                    agentAdresses.busAdresses[index] = address;
                    this.otherAddresses.add(agentAdresses);
                    logger.info((Object)("adding ====== " + address + " to " + bus));
                }
                if ((listener = this.membershipListeners[index]) == null) continue;
                String info = "";
                if (address instanceof UUID) {
                    info = ((UUID)address).toStringLong();
                }
                listener.connecting(name, info);
            }
        } else {
            block2: for (Address address : modifiedMembers) {
                String name = address.toString();
                if ("__".equals(name)) {
                    Iterator<AgentAdresses> it = this.anonymousAddresses.iterator();
                    AgentAdresses agentAdressesToRemove = null;
                    while (it.hasNext()) {
                        AgentAdresses agentAdresses = it.next();
                        Address storedAddress = agentAdresses.busAdresses[index];
                        if (!address.equals(storedAddress)) continue;
                        agentAdressesToRemove = agentAdresses;
                    }
                    if (agentAdressesToRemove == null) continue;
                    this.anonymousAddresses.remove(agentAdressesToRemove);
                    continue;
                }
                for (AgentAdresses agentAdresses : this.otherAddresses) {
                    if (!agentAdresses.agentName.equals(name)) continue;
                    agentAdresses.busAdresses[index] = null;
                    logger.info((Object)("removing ====== " + address + " from " + bus));
                    BusMembershipListener listener = this.membershipListeners[index];
                    if (listener == null) continue block2;
                    String info = "";
                    if (address instanceof UUID) {
                        info = ((UUID)address).toStringLong();
                    }
                    listener.disconnecting(name, info);
                    continue block2;
                }
            }
        }
    }

    public void closeFor(String agentName, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.get(agentName)) != null) {
            AgentAdresses agentAdresses = null;
            if (!"__".equals(agentName)) {
                for (AgentAdresses agAddress : this.otherAddresses) {
                    if (!agentName.equals(agAddress.agentName)) continue;
                    agentAdresses = agAddress;
                    break;
                }
            }
            Bus[] busArray = buses;
            int n = buses.length;
            int n2 = 0;
            while (n2 < n) {
                Bus bus = busArray[n2];
                int index = bus.ordinal();
                JChannel channel = localAgentChannels.channels[index];
                if (channel != null) {
                    channel.close();
                }
                if (agentAdresses != null) {
                    agentAdresses.busAdresses[index] = null;
                }
                ++n2;
            }
        }
    }

    public void close() throws IOException {
        this.closed = true;
        for (String key : this.mapLocalChannels.keySet()) {
            logger.info((Object)("******** removing " + key));
            LocalAgentChannels localAgentChannels = this.mapLocalChannels.get(key);
            JChannel[] jChannelArray = localAgentChannels.channels;
            int n = localAgentChannels.channels.length;
            int n2 = 0;
            while (n2 < n) {
                JChannel channel = jChannelArray[n2];
                if (channel != null) {
                    channel.close();
                }
                ++n2;
            }
        }
    }

    public <T extends BusPayload> void sendMessage(String senderAgent, Bus<T> bus, T message, String ... destinations) throws IOException {
        LocalAgentChannels localAgentChannels;
        if (this.closed) {
            throw new TransportStateException("closing");
        }
        if (senderAgent == null) {
            throw new IllegalArgumentException("no sender agent");
        }
        if (bus == null) {
            throw new IllegalArgumentException("no bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message");
        }
        ArrayList<Address> listDestinationAddress = null;
        int index = bus.ordinal();
        ArrayList<String> failed = new ArrayList<String>();
        if (destinations.length != 0 && !"".equals(destinations[0]) && !"*".equals(destinations[0])) {
            listDestinationAddress = new ArrayList<Address>();
            String[] stringArray = destinations;
            int n = destinations.length;
            int n2 = 0;
            while (n2 < n) {
                String destination = stringArray[n2];
                boolean found = false;
                for (AgentAdresses agentAdresses : this.otherAddresses) {
                    if (!agentAdresses.agentName.equals(destination)) continue;
                    Address address = agentAdresses.busAdresses[index];
                    if (address != null) {
                        listDestinationAddress.add(address);
                    } else if (this.tryBroadcast) {
                        listDestinationAddress.add(null);
                        BusMembershipListener listener = this.membershipListeners[index];
                        if (listener != null) {
                            listener.anormalEvent((Exception)new DuplicateBusNameException(destination, " default broadcast"));
                        }
                        logger.info((Object)("trying broadcast instead of " + agentAdresses.agentName));
                    } else {
                        failed.add(destination);
                        logger.info((Object)("sending fail (closed)" + agentAdresses.agentName));
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    if (this.tryBroadcast) {
                        listDestinationAddress.add(null);
                        logger.info((Object)("trying broadcast instead of " + destination));
                    } else {
                        failed.add(destination);
                        logger.info((Object)("sending fail )" + destination));
                    }
                }
                ++n2;
            }
            for (AgentAdresses agentAdresses : this.anonymousAddresses) {
                Address address = agentAdresses.busAdresses[index];
                if (address == null) continue;
                listDestinationAddress.add(address);
            }
        }
        if ((localAgentChannels = this.mapLocalChannels.get(senderAgent)) == null) {
            throw new IllegalArgumentException("agent " + senderAgent + " not registered on " + bus);
        }
        JChannel channel = localAgentChannels.channels[index];
        if (channel == null) {
            throw new IllegalArgumentException("agent " + senderAgent + " not registered on " + bus);
        }
        try {
            if (listDestinationAddress == null) {
                channel.send(null, message);
            } else {
                boolean nullSent = false;
                for (Address dest : listDestinationAddress) {
                    if (dest == null) {
                        if (nullSent) continue;
                        nullSent = true;
                    }
                    channel.send(dest, message);
                }
            }
        }
        catch (Exception exc) {
            throw new IOException(exc);
        }
        if (failed.size() != 0) {
            throw new DestinationsException(failed.toArray());
        }
    }

    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.get(agentName)) == null) {
            throw new IllegalArgumentException(" agent " + agentName + "not registered");
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = localAgentChannels.receivers[bus.ordinal()];
            if (receiver == null) {
                throw new IllegalArgumentException(" agent " + agentName + "not registered on bus " + bus);
            }
            receiver.addForwarder(forwarder);
            ++n2;
        }
    }

    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        LocalAgentChannels localAgentChannels;
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (forwarder == null) {
            throw new IllegalArgumentException("no forwarder");
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        if ((localAgentChannels = this.mapLocalChannels.get(agentName)) == null) {
            return;
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            BusReceiver receiver = localAgentChannels.receivers[bus.ordinal()];
            if (receiver != null) {
                receiver.removeForwarder(forwarder);
            }
            ++n2;
        }
    }

    public void setMembershipListener(BusMembershipListener listener, Bus ... buses) {
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Bus[] busArray = buses;
        int n = buses.length;
        int n2 = 0;
        while (n2 < n) {
            Bus bus = busArray[n2];
            this.membershipListeners[bus.ordinal()] = listener;
            ++n2;
        }
    }

    class AgentAdresses {
        String agentName;
        Address[] busAdresses = new Address[Bus.values().length];

        AgentAdresses() {
        }
    }

    class BusReceiver
    extends ReceiverAdapter {
        Bus bus;
        JChannel curChan;
        CopyOnWriteArrayList<BusMessageForwarder> listForwarders;
        String agentName;

        BusReceiver(String agentName, Bus bus, JChannel curChan) {
            this.agentName = agentName;
            this.bus = bus;
            this.curChan = curChan;
            curChan.setReceiver((Receiver)this);
        }

        public void addForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                this.listForwarders = new CopyOnWriteArrayList();
            }
            this.listForwarders.add(forwarder);
        }

        public void removeForwarder(BusMessageForwarder forwarder) {
            if (this.listForwarders == null) {
                return;
            }
            this.listForwarders.remove(forwarder);
        }

        public void receive(Message message) {
            BusMessage busMess = (BusMessage)message.getObject();
            if (this.listForwarders != null) {
                String destination;
                if (JGroupsBusMessagingLayer.this.tryBroadcast && !"__".equals(this.agentName) && busMess instanceof Command && (destination = ((Command)busMess).getDestination()) != null && !"".equals(destination) && !"*".equals(destination)) {
                    String[] dests = destination.split(",");
                    boolean found = false;
                    String[] stringArray = dests;
                    int n = dests.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String dest = stringArray[n2];
                        if (destination.equalsIgnoreCase(dest)) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        return;
                    }
                }
                for (BusMessageForwarder forwarder : this.listForwarders) {
                    forwarder.update(busMess);
                }
            }
        }

        public void viewAccepted(View view) {
            JGroupsBusMessagingLayer.this.updateMapAdressesFromView(this.bus, this.curChan, view);
        }

        public void suspect(Address address) {
            int index = this.bus.ordinal();
            for (AgentAdresses agentAdresses : JGroupsBusMessagingLayer.this.otherAddresses) {
                Address localAddress = agentAdresses.busAdresses[index];
                if (!address.equals(localAddress)) continue;
                BusMembershipListener busMembershipListener = JGroupsBusMessagingLayer.this.membershipListeners[index];
                if (busMembershipListener != null) {
                    String info = "";
                    if (address instanceof UUID) {
                        info = ((UUID)address).toStringLong();
                    }
                    busMembershipListener.disconnecting(address.toString(), info);
                }
                agentAdresses.busAdresses[index] = null;
                break;
            }
        }
    }

    class LocalAgentChannels {
        String agentName;
        JChannel[] channels = new JChannel[Bus.values().length];
        BusReceiver[] receivers = new BusReceiver[Bus.values().length];

        LocalAgentChannels() {
        }
    }
}

