package org.lsst.ccs.bus.jgroups;

import org.apache.log4j.Logger;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.lsst.ccs.bus.*;
import org.lsst.ccs.utilities.dispatch.CommandFor;
import org.lsst.ccs.utilities.dispatch.ParallelCommandDispatcher;
import org.lsst.ccs.utilities.dispatch.ParallelDispatchProxy;


/**
 * Change with a complete rehaul of communication.
 * each subssytem will have its Jgroup address
 * and so messages cna be adressed to specific subsystems
 * view can also tell if a subssysem is down!
 *
 * @author bamade
 */
@Deprecated
public class JGroupsMessagingFactory extends MessagingFactory {
    protected static Logger log = Logger.getLogger("lsst.ccs.bus.jgroups");

    private MessagingApplicationLayer appLayer = new MessagingApplicationLayer();

    // due to ThreadLocal variables in appLayer each should be in a different Thread!
    private ParallelCommandDispatcher<CommandListener> dispatchCommands;
    //@TODO: is it necessary? (added later due to bug in dispatching)
    //private ParallelCommandDispatcher<CommandListener> dispatchReplies;

    private ParallelDispatchProxy<StatusListener> proxyStatus;
    private ParallelDispatchProxy<LogListener> proxyLog ;

    private ReceiverAdapter receiverCommands;
    private ReceiverAdapter receiverStatus;
    private ReceiverAdapter receiverLog;

    private GroupTopic commandTopic;
    private GroupTopic statusTopic;
    private GroupTopic logTopic;

    public JGroupsMessagingFactory() {
        log.info("JGROUPS: creating factory");
        try {
            //@TODO: parameterize protocol stack for groups
            commandTopic = GroupTopic.create("command", "UDP(mcast_port=26969)");
            statusTopic = GroupTopic.create("status", "UDP(mcast_port=36969)");
            logTopic = GroupTopic.create("log", "UDP(mcast_port=46969)");
        } catch (Exception e) {
            log.fatal("group creation", e);  //CHANGE and get Logger
            throw new Error("group communication cannot start: " + e);
        }
    }

    synchronized void initListenToCommand() {
        if (null == commandTopic.getAdapter()) {
            log.info("JGROUPS:initializing command listen");
            dispatchCommands = new ParallelCommandDispatcher<CommandListener>();
            //dispatchReplies = new ParallelCommandDispatcher<CommandListener>();
            receiverCommands = new ReceiverAdapter() {
                public void receive(Message msg) {
                    try {
                        Object payload = msg.getObject();
                        if (payload instanceof Command) {
                            final Command command = (Command) payload;
                            log.info("####receiving command: " + command);
                            //System.out.println("####receiving command: " + command);
                            //String name = Subsystem.getCurrentSubsystemName();
                            //log.info("command SUBSYSTEM NAME :"+name);
                            CommandFor<CommandListener> toBeDone = new CommandFor<CommandListener>() {
                                public void invokeOn(CommandListener listener) {
                                    // this is executed in a separate thread so calling applayer only here
                                    Command transformed = appLayer.receivingCommand(command);
                                    if (null != transformed) listener.onCommand(transformed);
                                }
                                public String toString() {
                                    return "CommandFor #" + command.hashCode() ;
                                }
                            };
                            dispatchCommands.dispatchCommand(toBeDone);
                        } else if (payload instanceof CommandAckOrReply) {
                            final CommandAckOrReply reply = (CommandAckOrReply) payload;
                            log.info("####receiving reply: "+reply.hashCode()+ "  " + reply);
                            //System.out.println("####receiving reply: " +reply.hashCode()+"  "+ reply);
                            //String name = Subsystem.getCurrentSubsystemName();
                            //log.info("reply SUBSYSTEM NAME :"+name);
                            CommandFor<CommandListener> toBeDone = new CommandFor<CommandListener>() {
                                public void invokeOn(CommandListener listener) {
                                    // this is executed in a separate thread so calling applayer only here
                                    CommandAckOrReply transformed = appLayer.receivingReply(reply);
                                    if (null != transformed){
                                        if(transformed instanceof CommandReply) {
                                            listener.onReply((CommandReply) transformed);
                                        } else {
                                        listener.onAck((CommandAck)transformed);
                                        }
                                    }
                                }
                                public String toString() {
                                    return "ReplyFor #" + reply.hashCode() ;
                                }
                            };
                            dispatchCommands.dispatchCommand(toBeDone);
                            //dispatchReplies.dispatchCommand(toBeDone);
                        } else {
                            log.warn("Message payload type "
                                    + payload.getClass().getName()
                                    + " not handled " + payload);
                        }
                    } catch (Exception exc) {
                        log.error("object not deserialized: ", exc);
                    }
                }
            };
            commandTopic.setAdapter(receiverCommands);

        }

    }

    @Override
    public void addCommandListener(CommandListener l) {
        initListenToCommand();
        dispatchCommands.addExecutant(l);
    }

    @Override
    public void removeCommandListener(CommandListener l) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    synchronized void initListenToStatus() {
        if (null == statusTopic.getAdapter()) {
            log.info("JGROUPS: initializing status listen");
            proxyStatus = new ParallelDispatchProxy<StatusListener>(StatusListener.class);
            receiverStatus = new ReceiverAdapter() {
                StatusListener proxy = proxyStatus.getProxy();

                public void receive(Message msg) {
                    try {
                        Object payload = msg.getObject();
                        if (payload instanceof Status) {
                            Status status = appLayer.receivingStatus((Status) payload);
                            if (null != status) proxy.onStatus(status);
                        } else {
                            log.warn("Message payload type "
                                    + payload.getClass().getName()
                                    + " not handled " + payload);
                        }
                    } catch (Exception exc) {
                        log.error("object not deserialized: ", exc);
                    }
                }
            };
            statusTopic.setAdapter(receiverStatus);
        }

    }

    @Override
    public void addStatusListener(StatusListener l) {
        initListenToStatus();
        proxyStatus.addExecutant(l);
    }

    @Override
    public void removeStatusListener(StatusListener l) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    synchronized void initListenToLog() {
        if (null == logTopic.getAdapter()) {
            log.info("JGROUPS: initializing log listen");
            proxyLog = new ParallelDispatchProxy<LogListener>(LogListener.class);
            receiverLog = new ReceiverAdapter() {
                LogListener proxy = proxyLog.getProxy();

                public void receive(Message msg) {
                    try {
                        Object payload = msg.getObject();
                        if (payload instanceof LogEvent) {
                            LogEvent event = appLayer.receivingLog((LogEvent) payload);
                            if (event != null) proxy.onLog(event);
                        } else {
                            log.warn("Message payload type "
                                    + payload.getClass().getName()
                                    + " not handled " + payload);
                        }
                    } catch (Exception exc) {
                        log.error("object not deserialized: ", exc);
                    }
                }
            };
            logTopic.setAdapter(receiverLog);
        }

    }

    @Override
    public void addLogListener(LogListener l) {
        initListenToLog();
        proxyLog.addExecutant(l);
    }

    @Override
    public void removeLogListener(LogListener l) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    // @TODO: implement, those filters????
    @Override
    public void addCommandListener(CommandListener l, String selector) {
        initListenToCommand();
        dispatchCommands.addExecutant(l);
    }

    @Override
    public void addStatusListener(StatusListener l, String selector) {
        initListenToStatus();
        proxyStatus.addExecutant(l);
    }

    @Override
    public void addLogListener(LogListener l, String selector) {
        initListenToLog();
        proxyLog.addExecutant(l);
    }

    @Override
    public void sendCommand(Command cmd) {
        //System.out.println("#### sending command ");
        Command todo = appLayer.commandForSending(cmd);
        if (null == todo) return;
        try {
            log.info("JGROUPS: sending command from" + MessagingFactory.getInstance().getSubsystemName() +
              "(" + cmd.getOrigin() +" ?) to " + cmd.getDestination());
            commandTopic.sendMessage(todo);
        } catch (Exception e) {
            log.error("sending command message", e);  //CHANGE and get Logger
        }
    }

    @Override
    public void sendStatus(Status status) {
        log.info("JGROUPS: sending status");
        Status todo = appLayer.statusForSending(status);
        if (null == todo) return;
        try {
            statusTopic.sendMessage(todo);
        } catch (Exception e) {
            log.error("sending status message", e);  //CHANGE and get Logger
        }
    }

    @Override
    public void sendLogEvent(LogEvent evt) {
        //System.out.println("JGROUPS: sending log");
        LogEvent todo = appLayer.logForSending(evt);
        if (null == todo) return;
        try {
            logTopic.sendMessage(todo);
        } catch (Exception e) {
            log.error("sending log message", e);  //CHANGE and get Logger
        }
    }

    @Override
    public String getToken() {
        return appLayer.getToken();
    }


    /* @TODO : has to be called on the same thread as the command check implementation*/
    @Override
    public void reply(CommandAckOrReply cmd) {
        //System.out.println("#### sending reply ");
        CommandAckOrReply todo = appLayer.replyForSending(cmd);
        try {
            commandTopic.sendMessage(todo);
        } catch (Exception e) {
            log.error("sending reply message", e);  //CHANGE and get Logger
        }
    }

     public boolean isReplyRequested() {
         return appLayer.isReplyRequested();
     }
    @Override
    public void noAutoReply() {
        appLayer.noAutoReply();
    }

    public void shutdownBusAccess() {
        GroupTopic.closeAll();
        //TODO: stop listening? to proxies?
    }
}
