package org.lsst.ccs.maven.plugin.properties;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/**
 * Generate log4j jndi properties
 * @goal log4j
 */
public class Log4jPropertiesFileGeneratorMojo1 extends AbstractMojo {

    /**
     * @parameter expression="${project}"
     */
    private MavenProject mavenProject;
    /**
     *
     * @parameter expression="${org.lsst.ccs.resources.directory}" default-value="${project.build.directory}"
     */
    private String resourcesDirectory;
    private OutputStreamWriter out;
    static final String lineSeparator = System.getProperty("line.separator");

    public void execute() throws MojoExecutionException {



        try {
            if (!resourcesDirectory.endsWith("/")) {
                resourcesDirectory += "/";
            }
            File targetDirectory = new File(resourcesDirectory);
            targetDirectory.mkdirs();
            File outputFile = new File(targetDirectory, "log4j.properties");
            out = new OutputStreamWriter(new FileOutputStream(outputFile));

            getLog().info("Generating output file " + outputFile.toString());

            out.write("log4j.rootLogger=info, stdout" + lineSeparator);
            out.write("log4j.appender.stdout=org.apache.log4j.ConsoleAppender" + lineSeparator);
            out.write("log4j.appender.stdout.layout=org.apache.log4j.PatternLayout" + lineSeparator);
            out.write("log4j.appender.stdout.layout.ConversionPattern=%d{ISO8601} - %m%n" + lineSeparator);
            out.write("log4j.logger.net.aubourg=debug" + lineSeparator);
            out.write("log4j.logger.lsst=debug" + lineSeparator);
            out.write("log4j.logger.lsst.ccs.Subsystem=debug" + lineSeparator);
            out.write("log4j.logger.org.springframework.aop=DEBUG" + lineSeparator);
            out.write("log4j.logger.org.springframework=DEBUG" + lineSeparator);
            out.write("log4j.logger.lsst.ccs.framework=debug");

            out.flush();
        } catch (Exception ffe) {
            throw new MojoExecutionException("Problem creating jndi.properties file ", ffe);
        }

    }
}
