/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.maven.plugin.distribution;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DistributionMojo
extends AbstractMojo {
    private MavenProject mavenProject;
    private String projectType;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static DocumentBuilder docBuilder;
    private static Transformer transformer;

    public void execute() throws MojoExecutionException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docFactory.newDocumentBuilder();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DistributionMojo.writeDistributionDefinitionFile(this.mavenProject, "distribution.xml", this.projectType);
        }
        catch (Exception ffe) {
            throw new MojoExecutionException("Problem creating distribution description file", ffe);
        }
    }

    private static void writeDistributionDefinitionFile(MavenProject mavenProject, String fileName, String projectType) throws MojoExecutionException {
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("ccs-distribution");
        rootElement.setAttribute("name", mavenProject.getArtifactId());
        rootElement.setAttribute("version", mavenProject.getArtifact().getBaseVersion());
        rootElement.setAttribute("mainJar", String.valueOf(mavenProject.getArtifactId()) + "-" + mavenProject.getArtifact().getBaseVersion() + "." + mavenProject.getPackaging());
        if (projectType != null && !"".equals(projectType)) {
            rootElement.setAttribute("type", projectType);
        }
        doc.appendChild(rootElement);
        DOMSource source = new DOMSource(doc);
        String buildDirectory = mavenProject.getBuild().getDirectory();
        buildDirectory = String.valueOf(buildDirectory) + FILE_SEPARATOR + "distribution" + FILE_SEPARATOR + "etc" + FILE_SEPARATOR + "DIST-INF";
        DistributionMojo.writeXMLFile(transformer, source, buildDirectory, fileName);
    }

    private static void addArtifactInformation(Element el, Artifact ar) {
        el.setAttribute("artifactId", ar.getArtifactId());
        el.setAttribute("groupId", ar.getGroupId());
        el.setAttribute("version", ar.getBaseVersion());
        el.setAttribute("scope", ar.getScope());
    }

    private static void writeXMLFile(Transformer t, DOMSource source, String outputDirectory, String fileName) throws MojoExecutionException {
        try {
            File dirFile = new File(outputDirectory);
            dirFile.mkdirs();
            File outputFile = new File(outputDirectory, fileName);
            StreamResult result = new StreamResult(new FileOutputStream(outputFile));
            t.transform(source, result);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem creating distribution description file", e);
        }
    }
}

