/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.maven.plugin.distribution;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class DistributionMojo
extends AbstractMojo {
    private MavenProject mavenProject;
    private OutputStreamWriter out;
    static final String FILE_SEPARATOR = System.getProperty("file.separator");
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final String PROFILE_PROPERTY = "org.lsst.ccs.transport.profile";

    public void execute() throws MojoExecutionException {
        String buildDirectory = this.mavenProject.getBuild().getDirectory();
        if (!buildDirectory.endsWith(FILE_SEPARATOR)) {
            buildDirectory = String.valueOf(buildDirectory) + FILE_SEPARATOR;
        }
        String transportDirectory = String.valueOf(buildDirectory) + "distribution" + FILE_SEPARATOR + "etc";
        File transportDirectoryFile = new File(transportDirectory);
        transportDirectoryFile.mkdirs();
        List<Profile> activeProfiles = DistributionMojo.getTransportProfiles(this.mavenProject);
        for (Profile p : activeProfiles) {
            File outputFile = new File(transportDirectoryFile, String.valueOf(p.getId()) + ".properties");
            try {
                this.out = new OutputStreamWriter(new FileOutputStream(outputFile));
                Properties props = p.getProperties();
                for (Object property : props.keySet()) {
                    if (property.equals(PROFILE_PROPERTY)) continue;
                    this.out.write(property + "=" + props.getProperty((String)property) + LINE_SEPARATOR);
                }
                if (p.getActivation() != null && p.getActivation().isActiveByDefault()) {
                    this.out.write("org.lsst.ccs.transport.default=true" + LINE_SEPARATOR);
                }
                this.out.flush();
            }
            catch (Exception ffe) {
                throw new MojoExecutionException("Problem creating " + p.getId() + ".properties file ", ffe);
            }
        }
    }

    public static List<Profile> getTransportProfiles(MavenProject project) {
        ArrayList<Profile> list = new ArrayList<Profile>();
        DistributionMojo.getTransportProfiles(project, list);
        return list;
    }

    public static void getTransportProfiles(MavenProject project, List<Profile> list) {
        List activeProfiles = project.getModel().getProfiles();
        for (Profile p : activeProfiles) {
            if (p.getProperties().getProperty(PROFILE_PROPERTY) == null) continue;
            list.add(p);
        }
        MavenProject parent = project.getParent();
        if (parent != null) {
            DistributionMojo.getTransportProfiles(parent, list);
        }
    }
}

