package org.lsst.ccs.maven.plugin.distribution;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/**
 * Created transport definition property files.
 *
 * @goal createTransportProperties
 */
public class DistributionMojo extends AbstractMojo {

    /**
     * @parameter expression="${project}"
     */
    private MavenProject mavenProject;
    private OutputStreamWriter out;
    static final String FILE_SEPARATOR = System.getProperty("file.separator");
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final String PROFILE_PROPERTY = "org.lsst.ccs.transport.profile";
    
    public void execute() throws MojoExecutionException {


        String buildDirectory = mavenProject.getBuild().getDirectory();
        if (!buildDirectory.endsWith(FILE_SEPARATOR)) {
            buildDirectory += FILE_SEPARATOR;
        }
        String transportDirectory = buildDirectory + "distribution" + FILE_SEPARATOR
                + "etc";

        File transportDirectoryFile = new File(transportDirectory);
        transportDirectoryFile.mkdirs();

        List<Profile> activeProfiles = getTransportProfiles(mavenProject);
        for (Profile p : activeProfiles) {
            File outputFile = new File(transportDirectoryFile, p.getId() + ".properties");

            try {
                out = new OutputStreamWriter(new FileOutputStream(outputFile));

                Properties props = p.getProperties();
                for (Object property : props.keySet()) {
                    if ( ! property.equals(PROFILE_PROPERTY) ) {
                        out.write(property + "=" + props.getProperty((String) property)+LINE_SEPARATOR);
                    }
                }
                out.flush();
            } catch (Exception ffe) {
                throw new MojoExecutionException("Problem creating "+p.getId()+".properties file ", ffe);
            }

        }



    }

    public static List<Profile> getTransportProfiles(MavenProject project) {
        List<Profile> list = new ArrayList<Profile>();
        getTransportProfiles(project, list);
        return list;
    }

    public static void getTransportProfiles(MavenProject project, List<Profile> list) {
        List<Profile> activeProfiles = project.getModel().getProfiles();
        for (Profile p : activeProfiles) {
            if (p.getProperties().getProperty(PROFILE_PROPERTY) != null) {
                list.add(p);
            }
        }
        MavenProject parent = project.getParent();
        if (parent != null) {
            getTransportProfiles(parent, list);
        }
    }
}
