/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Pong;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.services.AgentService;

public class InfluxDbClientService
implements AgentService,
ServiceLifecycle {
    private static final Logger LOG = Logger.getLogger(InfluxDbClientService.class.getName());
    @ConfigurationParameter(isFinal=true, category="InfluxDb")
    private String influxDbUrl;
    @ConfigurationParameter(isFinal=true, category="InfluxDb")
    private String influxDbName;
    @ConfigurationParameter(isFinal=true, category="InfluxDb")
    private String influxDbUsername;
    @ConfigurationParameter(isFinal=true, category="InfluxDb")
    private String influxDbPassword;
    @ConfigurationParameter(isFinal=true, category="InfluxDb", maxLength=10)
    private Map<String, String> globalTags = new HashMap<String, String>();
    private InfluxDB influxDb;

    @Override
    public String getAgentServiceName() {
        return "influxDbClientService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        if (BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.use.influxdb.service", "false").toLowerCase().equals("true")) {
            LOG.log(Level.INFO, "Starting InfluxDbClientService for agent {0}", agentInfo.getName());
            return true;
        }
        return false;
    }

    @Override
    public void preInit() {
        if (this.influxDbUrl != null && !this.influxDbUrl.isEmpty()) {
            this.influxDb = InfluxDBFactory.connect((String)this.influxDbUrl, (String)this.influxDbUsername, (String)this.influxDbPassword);
            this.influxDb = this.influxDb.setDatabase(this.influxDbName);
            Pong p = this.influxDb.ping();
            if (p == null || !p.isGood()) {
                throw new RuntimeException("Could not connect with InfluxDb " + p);
            }
        } else {
            throw new RuntimeException("When the InfluxDb service is activated, the URL and credetnials must be specified.");
        }
        this.influxDb = this.influxDb.enableBatch(BatchOptions.DEFAULTS.actions(2000).flushDuration(500).exceptionHandler((failedPoints, throwable) -> LOG.severe(throwable.toString())));
    }

    @Override
    public void preShutdown() {
        if (this.influxDb != null) {
            this.influxDb.close();
        }
    }

    public InfluxDB getInfluxDbClient() {
        return this.influxDb;
    }

    public Map<String, String> getGlobalTags() {
        return this.globalTags;
    }
}

