/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;

@Entity
@Immutable
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY, region="org.lsst.ccs.localdb.statusdb.model.AgentState")
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"agentName", "hashMD5"})})
@NaturalIdCache
public class AgentState
implements Serializable {
    private static final long serialVersionUID = -8367786148299296222L;
    private long id;
    private AgentDesc agentDesc;
    private Map<String, StateBundleDesc> componentStates = new HashMap<String, StateBundleDesc>();
    private byte[] hashMD5;

    protected AgentState() {
    }

    public AgentState(AgentDesc ad) {
        this.agentDesc = ad;
    }

    @Id
    @GeneratedValue(generator="ID_SEQUENCE_GENERATOR")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @NaturalId(mutable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="agentName")
    public AgentDesc getAgentDesc() {
        return this.agentDesc;
    }

    public void setAgentDesc(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    public Map<String, StateBundleDesc> getComponentStates() {
        return this.componentStates;
    }

    public void setComponentStates(Map<String, StateBundleDesc> componentStates) {
        this.componentStates = componentStates;
    }

    public static byte[] computeMD5(String agentName, Map<String, StateBundleDesc> stateBundleDescs) {
        StringBuilder sb = new StringBuilder();
        sb.append(agentName).append("*");
        for (Map.Entry<String, StateBundleDesc> e : new TreeMap<String, StateBundleDesc>(stateBundleDescs).entrySet()) {
            String c = e.getKey();
            byte[] md5 = e.getValue().getHashMD5();
            sb.append(c).append("/").append(Arrays.toString(md5)).append(":");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e1) {
            throw new RuntimeException(e1);
        }
    }

    @NaturalId(mutable=false)
    @Column(columnDefinition="varbinary(100)", nullable=false)
    public byte[] getHashMD5() {
        return this.hashMD5 == null ? null : Arrays.copyOf(this.hashMD5, this.hashMD5.length);
    }

    public void setHashMD5(byte[] hashMD5) {
        this.hashMD5 = hashMD5 == null ? null : Arrays.copyOf(hashMD5, hashMD5.length);
    }

    public Map<String, Map<String, String>> asFlatStatesMap(List<String> components) {
        HashMap<String, Map<String, String>> res = new HashMap<String, Map<String, String>>();
        if (components == null || components.isEmpty() || components.contains("")) {
            if (components != null && components.size() == 1) {
                return res;
            }
            for (Map.Entry<String, StateBundleDesc> entry : this.componentStates.entrySet()) {
                HashMap<String, String> flatMap = (HashMap<String, String>)res.get(entry.getKey());
                if (flatMap == null) {
                    flatMap = new HashMap<String, String>();
                    res.put(entry.getKey(), flatMap);
                }
                for (InnerStateDesc isd : entry.getValue().getComponentStates().values()) {
                    flatMap.put(isd.getEnumClassName(), isd.getEnumValue());
                }
            }
            return res;
        }
        for (String component : components) {
            StateBundleDesc sbd = this.componentStates.get(component);
            if (sbd == null) continue;
            HashMap<String, String> flatMap = new HashMap<String, String>();
            for (InnerStateDesc isd : sbd.getComponentStates().values()) {
                flatMap.put(isd.getEnumClassName(), isd.getEnumValue());
            }
            res.put(component, flatMap);
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.agentDesc.getAgentName()).append(":\n\t");
        TreeMap<String, Map<String, String>> flatMap = new TreeMap<String, Map<String, String>>(this.asFlatStatesMap(null));
        Map topStates = (Map)flatMap.remove("");
        for (Map.Entry sbd : topStates.entrySet()) {
            sb.append((String)sbd.getKey()).append(":").append((String)sbd.getValue()).append(", ");
        }
        sb.append("\n");
        for (Map.Entry entry : flatMap.entrySet()) {
            sb.append("\t").append((String)entry.getKey()).append(": ");
            for (Map.Entry sbd : ((Map)entry.getValue()).entrySet()) {
                sb.append((String)sbd.getKey()).append(":").append((String)sbd.getValue()).append(", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

