/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.util.List;
import org.lsst.ccs.rest.file.server.client.implementation.RestClient;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystem;
import org.lsst.ccs.rest.file.server.client.implementation.unixlike.AbstractPath;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;

class RestPath
extends AbstractPath {
    private final boolean isReadOnly;
    private final RestFileInfo presetInfo;
    private Boolean isVersionedFile;
    private RestFileSystem fileSystem;

    RestPath(RestFileSystem fileSystem, String path) {
        super(fileSystem, path);
        this.fileSystem = fileSystem;
        this.isReadOnly = false;
        this.presetInfo = null;
    }

    RestPath(RestFileSystem fileSystem, boolean absolute, List<String> path) {
        super(fileSystem, absolute, path);
        this.fileSystem = fileSystem;
        this.isReadOnly = false;
        this.presetInfo = null;
    }

    synchronized boolean isVersionedFile() throws IOException {
        if (this.isVersionedFile == null) {
            RestFileInfo info = this.getClient().getRestFileInfo(this);
            this.isVersionedFile = info.isVersionedFile();
        }
        return this.isVersionedFile != null && this.isVersionedFile != false;
    }

    String getRestPath() {
        return this.toAbsolutePath().toString().substring(1);
    }

    RestClient getClient() {
        return ((RestFileSystem)this.getFileSystem()).getClient();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public URI toUri() {
        return this.fileSystem.getURI(this.toAbsolutePath().toString().substring(1));
    }
}

