/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentMBeanService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.alert.AlertService;

public class MessagingService
implements AgentService,
ServiceLifecycle {
    private static final Logger LOG = Logger.getLogger(MessagingService.class.getName());
    private volatile AgentMessagingLayer messagingAccess;
    private volatile boolean isConnectedToTheBuses = false;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentMBeanService mbeanService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;

    @Override
    public String getAgentServiceName() {
        return "messagingService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return true;
    }

    @Override
    public void preBuild() {
        this.messagingAccess = AgentMessagingLayer.createInstance((AgentInfo)this.agent.getAgentInfo(), (LockLevelService)this.agentLockService);
    }

    @Override
    public void afterBuild() {
        TreeWalkerUtils.proceduralWalk(this.agent.getComponentLookup(), null, AgentService.class, agentService -> {
            if (agentService instanceof BusMessagePreProcessor) {
                this.messagingAccess.addBusMessagePreProcessor((BusMessagePreProcessor)agentService);
            }
        }, null);
    }

    public AgentMessagingLayer getMessagingAccess() {
        if (this.messagingAccess == null) {
            throw new RuntimeException("The messaging access instance has not been created yet.");
        }
        return this.messagingAccess;
    }

    public boolean isConnectedToTheBuses() {
        return this.isConnectedToTheBuses;
    }

    @Override
    public void preStart() {
        this.connectToTheBuses();
        this.agent.getAgentInfo().setAgentJoinedTheBusesTime();
    }

    private synchronized void connectToTheBuses() {
        if (this.isConnectedToTheBuses) {
            throw new RuntimeException("This agent is already connected to the buses");
        }
        this.isConnectedToTheBuses = true;
        this.getMessagingAccess().connectToBuses();
        this.agent.initLogBusHandler();
        this.getMessagingAccess().setCommandExecutor((CommandExecutor)this.agent);
        try {
            if (this.mbeanService != null) {
                this.mbeanService.registerMBean(this.getMessagingAccess(), new ObjectName("org.lsst.ccs.mbean:type=MessagingLayer"));
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }
}

