/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.text.DateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.CommandRejectedException;
import org.lsst.ccs.messaging.StatusMessageListener;

public final class ConcurrentMessagingUtils {
    private final AgentMessagingLayer agentMessagingLayer;
    private static final Object NULL = new Object();
    private volatile Duration defaultTimeout;

    public ConcurrentMessagingUtils(AgentMessagingLayer agentMessagingLayer) {
        this(agentMessagingLayer, Duration.ofSeconds(5L));
    }

    public ConcurrentMessagingUtils(AgentMessagingLayer agentMessagingLayer, Duration defaultTimeout) {
        this.agentMessagingLayer = agentMessagingLayer;
        this.defaultTimeout = defaultTimeout;
    }

    public void setDefaultTimeout(Duration defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public Duration getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public Object sendSynchronousCommand(CommandRequest command) throws Exception {
        return this.invokeIt(false, command, this.defaultTimeout, false);
    }

    @Deprecated
    public Object sendSynchronousCommand(CommandRequest command, long millisTimeout) throws Exception {
        return this.invokeIt(false, command, Duration.ofMillis(millisTimeout), true);
    }

    public Object sendSynchronousCommand(CommandRequest command, Duration timeout) throws Exception {
        return this.invokeIt(false, command, timeout, true);
    }

    public Future<Object> sendAsynchronousCommand(CommandRequest command) {
        LinkedCommandOriginator commandOriginator = new LinkedCommandOriginator(false, this.agentMessagingLayer);
        LinkedFuture<Object> linkedFuture = new LinkedFuture<Object>(commandOriginator, false);
        linkedFuture.init();
        this.agentMessagingLayer.sendCommandRequest(command, commandOriginator);
        return linkedFuture;
    }

    @Deprecated
    public Object getAckForCommand(CommandRequest command, long millisTimeout) throws Exception {
        return this.invokeIt(true, command, Duration.ofMillis(millisTimeout), true);
    }

    public Object getAckForCommand(CommandRequest command, Duration timeout) throws Exception {
        return this.invokeIt(true, command, timeout, true);
    }

    private Object invokeIt(boolean ackOnly, CommandRequest command, Duration timeout, boolean isTimeoutUserProvided) throws Exception {
        long timeoutMillis = 0L;
        TimeUnit timeoutUnits = TimeUnit.MILLISECONDS;
        if (timeout == null) {
            if (isTimeoutUserProvided) {
                throw new IllegalArgumentException("Provided timeout cannot be null");
            }
            timeoutMillis = -1L;
        } else {
            timeoutMillis = timeout.toMillis();
        }
        LinkedCommandOriginator commandOriginator = new LinkedCommandOriginator(ackOnly, this.agentMessagingLayer);
        SynchLinkedFuture<Object> linkedFuture = new SynchLinkedFuture<Object>(commandOriginator, false, isTimeoutUserProvided);
        linkedFuture.init();
        commandOriginator.addEvent("Sending command " + command.getBasicCommand().getCommand());
        this.agentMessagingLayer.sendCommandRequest(command, commandOriginator);
        commandOriginator.addEvent("Command sent.");
        try {
            Object res = linkedFuture.get(timeoutMillis, timeoutUnits);
            if (res instanceof Exception) {
                throw (Exception)res;
            }
            return res;
        }
        catch (TimeoutException x) {
            commandOriginator.addEvent("Timing out.");
            throw (TimeoutException)new TimeoutException(x.getMessage() + "\n" + commandOriginator.getTrace()).initCause(x);
        }
    }

    @Deprecated
    public Future<StatusMessage> startListeningForStatusBusMessage(Predicate<BusMessage<? extends Serializable, ?>> filter, long timeout) {
        LinkedStatusBusListener innerListener = new LinkedStatusBusListener(filter, timeout, this.agentMessagingLayer);
        LinkedFuture<StatusMessage> future = new LinkedFuture<StatusMessage>(innerListener, true);
        future.init();
        this.agentMessagingLayer.addStatusMessageListener(innerListener, filter);
        return future;
    }

    public Future<StatusMessage> startListeningForStatusBusMessage(Predicate<BusMessage<? extends Serializable, ?>> filter, Duration timeout) {
        LinkedStatusBusListener innerListener = new LinkedStatusBusListener(filter, timeout.toMillis(), this.agentMessagingLayer);
        LinkedFuture<StatusMessage> future = new LinkedFuture<StatusMessage>(innerListener, true);
        future.init();
        this.agentMessagingLayer.addStatusMessageListener(innerListener, filter);
        return future;
    }

    public Future<StatusMessage> startListeningForStatusBusMessage(Predicate<BusMessage<? extends Serializable, ?>> f) {
        return this.startListeningForStatusBusMessage(f, Duration.ofMillis(-1L));
    }

    class SynchLinkedFuture<T>
    extends LinkedFuture {
        private final boolean isTimeoutUserProvided;

        SynchLinkedFuture(LinkedTask<T> task, boolean throwException, boolean isTimeoutUserProvided) {
            super(task, throwException);
            this.isTimeoutUserProvided = isTimeoutUserProvided;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long pollTimeout;
            if (this.isTimeoutUserProvided) {
                pollTimeout = timeout;
            } else {
                long start = System.currentTimeMillis();
                Duration internalTaskDuration = this.task.getTaskInternalTimeout(unit.toMillis(timeout));
                if (internalTaskDuration != null) {
                    timeout = internalTaskDuration.toMillis();
                    unit = TimeUnit.MILLISECONDS;
                }
                pollTimeout = timeout - (System.currentTimeMillis() - start);
            }
            try {
                return super.get(pollTimeout, unit);
            }
            catch (TimeoutException x) {
                throw (TimeoutException)new TimeoutException("Timed out after " + TimeUnit.MILLISECONDS.toSeconds(timeout) + " seconds.").initCause(x);
            }
        }
    }

    class LinkedFuture<T>
    implements Future<T> {
        private final LinkedTransferQueue<Object> queue = new LinkedTransferQueue();
        protected final LinkedTask<T> task;
        private boolean isCancelled = false;
        private final boolean throwException;
        private boolean initialized = false;
        private final Object initLock = new Object();

        LinkedFuture(LinkedTask<T> task, boolean throwException) {
            this.task = task;
            this.throwException = throwException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void init() {
            Object object = this.initLock;
            synchronized (object) {
                if (this.initialized) {
                    throw new RuntimeException("LinkedFuture must be initialized only once");
                }
                this.initialized = true;
            }
            this.task.setLinkedFuture(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    throw new RuntimeException("LinkedFuture must be initialized first");
                }
            }
            return this.isCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    throw new RuntimeException("LinkedFuture must be initialized first");
                }
            }
            return !this.queue.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    throw new RuntimeException("LinkedFuture must be initialized first");
                }
                if (this.isCancelled) {
                    return false;
                }
                this.isCancelled = true;
            }
            this.task.cancel();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException, ExecutionException {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    throw new RuntimeException("LinkedFuture must be initialized first");
                }
            }
            return this.processReply(this.queue.take());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    throw new RuntimeException("LinkedFuture must be initialized first");
                }
            }
            long time = timeout > 0L ? timeout : 1L;
            Object reply = this.queue.poll(time, unit);
            if (reply == null) {
                throw new TimeoutException("Could not get reply within the specified timeout of " + timeout + " " + unit.toString().toLowerCase());
            }
            return this.processReply(reply);
        }

        private T processReply(Object reply) throws InterruptedException, ExecutionException {
            if (reply instanceof Exception && this.throwException) {
                throw new ExecutionException("Execution Exception", (Exception)reply);
            }
            return (T)(reply != NULL ? reply : null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToQueue(Object obj) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    throw new RuntimeException("LinkedFuture must be initialized first");
                }
            }
            if (obj == null) {
                obj = NULL;
            }
            this.queue.offer(obj);
            this.task.stop();
        }
    }

    abstract class LinkedTask<T> {
        LinkedFuture<T> future = null;

        LinkedTask() {
        }

        public abstract void cancel();

        public abstract void start();

        public abstract void stop();

        public abstract Duration getTaskInternalTimeout(long var1);

        void setLinkedFuture(LinkedFuture<T> future) {
            this.future = future;
            this.start();
        }

        LinkedFuture<T> getLinkedFuture() {
            return this.future;
        }
    }

    private class LinkedCommandOriginator
    extends LinkedTask<Object>
    implements CommandOriginator {
        private final boolean getAckOnly;
        private Duration timeout;
        private boolean gotAck = false;
        private final Object ackLock = new Object();
        private final ArrayList<Event> trace = new ArrayList();

        LinkedCommandOriginator(boolean ackOnly, AgentMessagingLayer agentMessagingLayer) {
            this.getAckOnly = ackOnly;
            this.addEvent("Constructed command originator.");
        }

        @Override
        public void cancel() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Duration getTaskInternalTimeout(long tout) {
            this.addEvent("Asking for custom timeout, wait for " + tout + " ms.");
            long deadline = System.currentTimeMillis() + tout;
            try {
                Object object = this.ackLock;
                synchronized (object) {
                    while (!this.gotAck && tout > 0L) {
                        this.ackLock.wait(tout);
                        tout = deadline - System.currentTimeMillis();
                    }
                }
                this.addEvent("Obtained custom timeout: " + (this.timeout == null ? "none" : this.timeout.getSeconds() + " seconds."));
                return this.timeout;
            }
            catch (InterruptedException ie) {
                this.addEvent("Wait for custom timeout is interrupted");
                throw new RuntimeException("Interrupted while waiting for ACK ", ie);
            }
        }

        @Override
        public void processNack(CommandNack nack) {
            this.addEvent("Received NACK.");
            CommandRejectedException rejection = new CommandRejectedException(nack);
            this.getLinkedFuture().addToQueue(rejection);
        }

        @Override
        public void processResult(CommandResult result) {
            Object resultContent;
            this.addEvent("Received result: " + result);
            if (this.getAckOnly) {
                return;
            }
            try {
                resultContent = result.getResult();
            }
            catch (Exception e) {
                resultContent = result.getEncodedData();
            }
            this.getLinkedFuture().addToQueue(resultContent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processAck(CommandAck ack) {
            this.addEvent("Received ACK.");
            Object object = this.ackLock;
            synchronized (object) {
                this.timeout = ack.getTimeout();
                this.gotAck = true;
                this.ackLock.notifyAll();
            }
            if (this.getAckOnly) {
                this.getLinkedFuture().addToQueue(ack);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addEvent(Object event) {
            ArrayList<Event> arrayList = this.trace;
            synchronized (arrayList) {
                this.trace.add(new Event(event));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getTrace() {
            DateFormat form = DateFormat.getTimeInstance(2);
            StringBuilder sb = new StringBuilder("Command trace:\n");
            long prev = 0L;
            ArrayList<Event> arrayList = this.trace;
            synchronized (arrayList) {
                for (Event e : this.trace) {
                    sb.append(form.format(new Date(e.time))).append(" ").append(e.content);
                    if (prev > 0L) {
                        sb.append(" ( + ").append(e.time - prev).append(" ms)");
                    }
                    prev = e.time;
                    sb.append("\n");
                }
            }
            return sb.toString();
        }

        private class Event {
            final long time = System.currentTimeMillis();
            final Object content;

            Event(Object content) {
                this.content = content;
            }

            public long getTime() {
                return this.time;
            }

            public Object getContent() {
                return this.content;
            }
        }
    }

    class LinkedStatusBusListener
    extends LinkedTask<StatusMessage>
    implements StatusMessageListener {
        private final Predicate<BusMessage<? extends Serializable, ?>> filter;
        private final Timer timeoutTimer = new Timer("LinkedStatusBusListener");
        private boolean cleanedUp = false;
        private final AgentMessagingLayer agentMessagingLayer;
        private final long timeout;

        LinkedStatusBusListener(Predicate<BusMessage<? extends Serializable, ?>> filter, long timeout, AgentMessagingLayer agentMessagingLayer) {
            this.filter = filter;
            this.agentMessagingLayer = agentMessagingLayer;
            this.timeout = timeout;
        }

        @Override
        public void start() {
            if (this.timeout > 0L) {
                this.timeoutTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        this.cancel();
                        TimeoutException ex = new TimeoutException("Timeout listening for filtered events " + LinkedStatusBusListener.this.filter.toString());
                        LinkedStatusBusListener.this.getLinkedFuture().addToQueue(ex);
                    }
                }, this.timeout);
            }
        }

        @Override
        public Duration getTaskInternalTimeout(long tout) {
            return null;
        }

        @Override
        public void stop() {
            this.cancel();
        }

        @Override
        public void cancel() {
            if (!this.cleanedUp) {
                this.agentMessagingLayer.removeStatusMessageListener(this);
                this.cleanedUp = true;
            }
        }

        @Override
        public void onStatusMessage(StatusMessage bm) {
            if (!this.getLinkedFuture().isDone()) {
                this.timeoutTimer.cancel();
                this.getLinkedFuture().addToQueue(bm);
            }
        }
    }
}

