/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.utilities.conv.TypeUtils;

public abstract class HollowParm<T extends Serializable>
implements Serializable,
Cloneable {
    protected T value;
    protected boolean set;
    protected boolean readOnly = false;
    protected Properties properties;

    protected HollowParm() {
    }

    protected HollowParm(T value) {
        this.value = value;
        if (value != null) {
            this.set = true;
        }
    }

    protected HollowParm(T value, Map<?, ?> map) {
        this(value);
        this.setProperties(map);
    }

    final void setProperties(Map<?, ?> map) {
        this.properties = new Properties();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object valProp = entry.getValue();
            String valPropStr = valProp instanceof BigDecimal ? ((BigDecimal)valProp).toPlainString() : String.valueOf(valProp);
            this.properties.setProperty(entry.getKey().toString(), valPropStr);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        if (this.readOnly) {
            return;
        }
        this.value = value;
        this.set = value != null;
    }

    public void setNullValue() {
        if (this.readOnly) {
            return;
        }
        this.value = null;
        this.set = true;
    }

    public void clear() {
        if (this.readOnly) {
            return;
        }
        this.setValue(null);
    }

    public void modifyChecked(T obj) {
        if (this.readOnly) {
            return;
        }
        if (obj == null) {
            this.setNullValue();
            return;
        }
        this.setValue(obj);
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String toString() {
        return TypeUtils.stringify(this.value);
    }

    public abstract Class<T> getValueClass();

    public HollowParm<T> addProperties(Map.Entry<String, String> ... entries) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        Map.Entry<String, String>[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<String, String> entry = entryArray[n2];
            this.properties.setProperty(entry.getKey(), entry.getValue());
            ++n2;
        }
        return this;
    }

    public HollowParm clone() {
        HollowParm nextOne = null;
        try {
            nextOne = (HollowParm)super.clone();
            if (this.properties != null) {
                nextOne.properties = (Properties)this.properties.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return nextOne;
    }
}

