/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.AlarmNotClearedException;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.RaisedAlertBookkeeper;
import org.lsst.ccs.SignalsStillRunning;
import org.lsst.ccs.SystemStateException;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.logging.TextFormatter;

public class Subsystem
extends Agent {
    private final RaisedAlertBookkeeper raisedAlertBookkeeper;
    private final List<ClearAlertHandler> clearAlertHandlers = new ArrayList<ClearAlertHandler>();
    private final Object alertLock = new Object();
    private static final Logger sub_log = Logger.getLogger((String)"org.lsst.ccs.subsystem");

    public Subsystem(String name, AgentInfo.AgentType type) {
        super(name, type);
        this.raisedAlertBookkeeper = new RaisedAlertBookkeeper();
    }

    @Override
    protected final boolean internalStart() {
        this.doStart();
        try {
            this.checkHardware();
            this.completeInitialization(true);
        }
        catch (HardwareException e) {
            sub_log.error((Object)"check hardware problem ", (Throwable)((Object)e));
            this.updateInternalState(StackTraceFormats.toString((Throwable)((Object)e)), new AgentState[]{OperationalState.ENGINEERING_FAULT});
            return false;
        }
        return true;
    }

    @Override
    protected final void internalShutdown() throws Exception {
        try {
            this.checkAllHardwareStopped();
        }
        catch (HardwareException exc) {
            this.raiseAlert(new Alert("Problems stopping hardware", exc.getMessage()), AlertState.ALARM);
            sub_log.error((Object)"Problems stopping hardware", (Throwable)((Object)exc));
            throw exc;
        }
        sub_log.fine((Object)"Hardware is stopped");
        this.doShutdown();
        this.clearAlertHandlers.clear();
    }

    public void completeInitialization(boolean checkHardwareOK) throws HardwareException {
        if (!checkHardwareOK) {
            this.checkAllHardwareStarted();
        }
        this.postStart();
        this.updateInternalState(null, new AgentState[]{PhaseState.OPERATIONAL, OperationalState.ENGINEERING_OK});
    }

    public void postStart() throws HardwareException {
    }

    public Logger getLogger() {
        return sub_log;
    }

    public void checkHardware() throws HardwareException {
    }

    public void checkAllHardwareStarted() throws HardwareException {
    }

    public void checkAllHardwareStopped() throws HardwareException {
    }

    public void doStart() {
    }

    public void doShutdown() {
    }

    @Command(description="completes initialization after hardware problems corrections", type=Command.CommandType.ACTION)
    public void completeInitialization() throws SystemStateException, HardwareException {
        if (!this.isInState((Enum)PhaseState.INITIALIZING)) {
            throw new SystemStateException("initialization already completed");
        }
        this.completeInitialization(false);
    }

    @Command(description="forces blocked shutdown (not implemented yet!)", type=Command.CommandType.SIGNAL)
    public void forceShutdown() {
    }

    @Command(description="abort subsystem", type=Command.CommandType.SIGNAL)
    public void abort() {
        sub_log.fine((Object)("Subsystem " + this.getName() + " abort requested"));
    }

    @Command(description="halt hardware with expected max delay", type=Command.CommandType.SIGNAL)
    public void abort(long expectedMaxDelay) {
        sub_log.fine((Object)("Subsystem " + this.getName() + " abort requested"));
    }

    @Command(description="stops hardware with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        sub_log.fine((Object)("Subsystem " + this.getName() + " stop requested"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="switch to ENGINEERING mode", type=Command.CommandType.ACTION)
    public boolean switchToEngineeringMode() {
        Object object = this.innerStateLock;
        synchronized (object) {
            if (this.isInState((Enum)OperationalState.NORMAL)) {
                this.updateInternalState(null, new AgentState[]{OperationalState.ENGINEERING_OK});
                return true;
            }
        }
        return false;
    }

    @Command(description="Tries to get back to NORMAL mode", type=Command.CommandType.ACTION)
    public final void switchToNormalMode() throws SystemStateException {
        if (this.getState(AlertState.class).compareTo(AlertState.WARNING) > 0) {
            throw new AlarmNotClearedException();
        }
        if (this.getCommandCount(Command.CommandType.SIGNAL) != 0) {
            throw new SignalsStillRunning();
        }
        try {
            this.updateInternalState(null, new AgentState[]{CommandState.READY, OperationalState.NORMAL});
        }
        catch (IllegalArgumentException x) {
            throw new SystemStateException(x);
        }
    }

    public final void addClearAlertHandler(ClearAlertHandler handler) {
        this.clearAlertHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void raiseAlert(Alert alert, AlertState severity) {
        long ts = System.currentTimeMillis();
        Object object = this.alertLock;
        synchronized (object) {
            RaisedAlertHistory raisedAlert = this.raisedAlertBookkeeper.raiseAlert(alert, severity, ts);
            AlertState globalSeverity = this.raisedAlertBookkeeper.getAlertState();
            if (globalSeverity == AlertState.ALARM && !this.isInState((Enum)AlertState.ALARM)) {
                this.updateInternalState(alert.toString(), new AgentState[]{AlertState.ALARM, OperationalState.ENGINEERING_FAULT});
            } else if (globalSeverity == AlertState.WARNING && this.getState(AlertState.class).compareTo(AlertState.WARNING) < 0) {
                this.updateInternalState(alert.toString(), new AgentState[]{AlertState.WARNING});
            }
            sub_log.log(this.getLogLevelForAlertState(severity), "Raised Alert " + alert.getAlertId() + "(" + alert.getDescription() + "). Overall AlertState=" + globalSeverity.name(), (Object)"");
            StatusRaisedAlert statusAlert = new StatusRaisedAlert(raisedAlert.getLatestAlert(), this.getState(), this.getRaisedAlertSummary());
            this.getMessagingAccess().sendStatusMessage((StatusMessage)statusAlert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Clear alerts", type=Command.CommandType.ACTION)
    public final String[] clearAlerts(String ... alertId) {
        Object object = this.alertLock;
        synchronized (object) {
            String summary;
            ArrayList<String> clearedAlerts = new ArrayList<String>();
            for (String id : alertId) {
                boolean clearAlert = true;
                RaisedAlertHistory raisedAlert = this.raisedAlertBookkeeper.getRaisedAlert(id);
                if (raisedAlert != null) {
                    for (ClearAlertHandler handler : this.clearAlertHandlers) {
                        ClearAlertHandler.ClearAlertCode code = handler.canClearAlert(raisedAlert.getLatestAlert());
                        if (code == ClearAlertHandler.ClearAlertCode.CLEAR_ALERT) {
                            clearAlert = true;
                            continue;
                        }
                        if (code != ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT) continue;
                        clearAlert = false;
                        break;
                    }
                }
                if (!clearAlert) continue;
                this.raisedAlertBookkeeper.clearAlert(id);
                clearedAlerts.add(id);
            }
            String[] clearedIds = new String[clearedAlerts.size()];
            if (!clearedAlerts.isEmpty()) {
                String clearedIdsStr = "";
                for (String s : clearedAlerts) {
                    clearedIdsStr = clearedIdsStr + s + " ";
                }
                clearedIds = clearedAlerts.toArray(clearedIds);
                AlertState globalSeverity = this.raisedAlertBookkeeper.getAlertState();
                if (globalSeverity == AlertState.WARNING && this.isInState((Enum)AlertState.ALARM)) {
                    this.updateInternalState("Cleared Alerts " + clearedIdsStr, new AgentState[]{AlertState.WARNING, OperationalState.ENGINEERING_OK});
                } else if (globalSeverity == AlertState.NOMINAL && !this.isInState((Enum)AlertState.NOMINAL)) {
                    this.updateInternalState("Cleared Alerts " + clearedIdsStr, new AgentState[]{AlertState.NOMINAL, OperationalState.ENGINEERING_OK});
                }
                StatusClearedAlert clearedStatus = new StatusClearedAlert(clearedIds, this.getState(), this.getRaisedAlertSummary());
                this.getMessagingAccess().sendStatusMessage((StatusMessage)clearedStatus);
            }
            if (clearedIds.length > 0) {
                summary = "Cleared Alert Id" + (clearedIds.length > 1 ? "s" : "") + " (";
                for (int i = 0; i < clearedIds.length; ++i) {
                    summary = summary + clearedIds[i];
                    if (i >= clearedIds.length - 1) continue;
                    summary = summary + ", ";
                }
                summary = summary + ")";
            } else {
                summary = "Attempt to clear alerts, but no Alerts were cleared";
            }
            sub_log.info((Object)(summary + " the resulting Alert State is " + this.raisedAlertBookkeeper.getAlertState().name()));
            return clearedIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Clear all alerts", type=Command.CommandType.ACTION)
    public final String[] clearAllAlerts() {
        Object object = this.alertLock;
        synchronized (object) {
            Set alerts = this.raisedAlertBookkeeper.getAllRaisedAlertHistories();
            String[] alertId = new String[alerts.size()];
            int count = 0;
            for (RaisedAlertHistory alert : alerts) {
                alertId[count++] = alert.getLatestAlert().getAlertId();
            }
            return this.clearAlerts(alertId);
        }
    }

    private Level getLogLevelForAlertState(AlertState state) {
        if (state == AlertState.ALARM) {
            return Level.SEVERE;
        }
        if (state == AlertState.WARNING) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    @Command(description="Get the Raised Alert Summary", type=Command.CommandType.QUERY)
    public final RaisedAlertSummary getRaisedAlertSummary() {
        return this.raisedAlertBookkeeper;
    }

    @Command(description="set the level of the BusLogHandler", type=Command.CommandType.QUERY)
    public void setBusLogHandlerLevel(String levelName) {
        if (this.logBusHandler != null) {
            Level level = Level.parse(levelName);
            this.logBusHandler.setLevel(level);
        }
    }

    @Command(description="set the level of a Logger", type=Command.CommandType.QUERY)
    public void setLogLevel(String keyLogger, String levelName) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(keyLogger);
        Level level = Level.parse(levelName);
        logger.setLevel(level);
    }

    @Command(description="sets the the depth of stacktraces in Logger messages", type=Command.CommandType.QUERY)
    public void setStackTraceDepth(int depth) {
        StackTraceFormats.setDepth((int)depth);
    }

    @Command(description="sets the format used by TextFormatter for LogEvent messages ", type=Command.CommandType.QUERY)
    public void setLogFormat(String format) {
        Formatter formatter = this.logBusHandler.getFormatter();
        if (!(formatter instanceof TextFormatter)) {
            throw new IllegalArgumentException(" formatter to LogBusHandler not a TextFormatter");
        }
        TextFormatter textFormatter = (TextFormatter)formatter;
        textFormatter.setFormat(format);
    }

    @Command(description="sets the handler (ConsoleHandler, FileHandler, LogBusHandler) log level", type=Command.CommandType.QUERY)
    public void setLogHandlerLevel(String handler, String level) {
        block2: {
            Handler[] handlers;
            block1: {
                if (!handler.equals("LogBusHandler")) break block1;
                if (this.logBusHandler == null) break block2;
                Level newLevel = Level.parse(level);
                this.logBusHandler.setLevel(newLevel);
                break block2;
            }
            java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
            for (Handler h : handlers = rootLogger.getHandlers()) {
                if (!h.getClass().getSimpleName().equals(handler)) continue;
                Level newLevel = Level.parse(level);
                h.setLevel(newLevel);
                break;
            }
        }
    }

    @Command(description="tries to stop the panic state of logmanagement", type=Command.CommandType.QUERY)
    public void removeLogPanicState() {
        if (this.logBusHandler != null) {
            this.logBusHandler.setPanicState(false);
        }
    }

    @Command(description="gets the number of commands which are currently running (except the current one!)", type=Command.CommandType.QUERY)
    public int getNumberCommandThreads() {
        return this.getCommandCount(new Command.CommandType[0]);
    }

    @Command(description="gets the name of commands which are currently running", type=Command.CommandType.QUERY)
    public String printRunningCommands() {
        Agent.RunningCommand action;
        StringBuilder sb = new StringBuilder();
        HashSet commands = new HashSet(this.currentQueries);
        if (commands.size() > 1) {
            sb.append("Queries:\n");
            commands.forEach(task -> {
                if (!task.request.getBasicCommand().getCommand().equals("printRunningCommands")) {
                    sb.append(task).append("\n");
                }
            });
        }
        if ((action = this.currentAction) != null) {
            sb.append("Actions:\n").append(action).append("\n");
        }
        if (!(commands = new HashSet(this.currentQueries)).isEmpty()) {
            sb.append("Signals:\n");
            commands.forEach(task -> sb.append(task).append("\n"));
        }
        return sb.toString();
    }

    @Command(description="broadcast on the status bus a message of presence", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void ping() {
        this.broadcastStatus();
    }
}

