/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.PathObject;

@MappedSuperclass
public abstract class SubsystemDescription
implements Serializable {
    private long startTimestamp;
    private long endTimestamp = PackCst.STILL_VALID;
    private String subsystemName;
    private String tag;
    @Lob
    protected Serializable descriptionData;
    private long previousDescriptionID;

    SubsystemDescription() {
    }

    protected SubsystemDescription(String subsystemName, String tag, Serializable descriptionData) {
        this.setSubsystemName(subsystemName);
        this.setTag(tag);
        if (descriptionData == null) {
            throw new IllegalArgumentException("null configuration data");
        }
        this.descriptionData = descriptionData;
    }

    protected SubsystemDescription(SubsystemDescription other) {
        this(other.getSubsystemName(), other.getTag(), other.getDescriptionData());
    }

    public abstract long getId();

    abstract void setId(long var1);

    public abstract Map<ParameterPath, ? extends ParameterDescription> getParamDescriptionMap();

    public abstract Set<String> getCategorySet();

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    void setSubsystemName(String subsystemName) {
        if (subsystemName == null) {
            throw new IllegalArgumentException("null subsystemName");
        }
        this.subsystemName = subsystemName;
    }

    public String getTag() {
        return this.tag;
    }

    void setTag(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.tag = tag;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public Serializable getDescriptionData() {
        return this.descriptionData;
    }

    void setDescriptionData(Serializable descriptionData) {
        this.descriptionData = descriptionData;
    }

    public long getPreviousDescriptionID() {
        return this.previousDescriptionID;
    }

    void setPreviousDescriptionID(long previousDescriptionID) {
        this.previousDescriptionID = previousDescriptionID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubsystemDescription)) {
            return false;
        }
        SubsystemDescription that = (SubsystemDescription)o;
        if (this.getId() != that.getId()) {
            return false;
        }
        if (!this.getSubsystemName().equals(that.getSubsystemName())) {
            return false;
        }
        String tag = this.getTag();
        return !(tag != null ? !tag.equals(that.getTag()) : that.getTag() != null);
    }

    public int hashCode() {
        int result = this.getSubsystemName().hashCode();
        String tag = this.getTag();
        result = 31 * result + (tag != null ? tag.hashCode() : 0);
        long id = this.getId();
        result = 31 * result + (int)(id ^ id >>> 32);
        return result;
    }

    public String toString() {
        return "{id=" + this.getId() + "; name/tag=" + this.subsystemName + "/" + this.tag + ";descriptions=" + this.getParamDescriptionMap() + '}';
    }

    public ParameterDescription fetch(PathObject path) {
        return this.getParamDescriptionMap().get(path.getPath());
    }

    public ParameterDescription fetch(String pathString) {
        return this.fetch(ParameterPath.valueOf(pathString));
    }

    public abstract void addParameterDescriptions(ParameterDescription ... var1);

    public abstract void addParameterDescriptions(Collection<ParameterDescription> var1);

    public abstract void removeParameterDescriptions(ParameterDescription ... var1);
}

