/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.List;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.PathObject;
import org.lsst.ccs.config.ValueEvent;

@MappedSuperclass
public abstract class ParameterConfiguration
implements Serializable,
PathObject {
    protected String configuredValue;
    @Transient
    protected Exception reConfigurationFailure;

    protected ParameterConfiguration() {
    }

    protected ParameterConfiguration(String value) {
        this.configuredValue = value;
    }

    public abstract long getId();

    protected abstract void setId(long var1);

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    public Exception getReConfigurationFailure() {
        return this.reConfigurationFailure;
    }

    public void setReConfigurationFailure(Exception reConfigurationFail) {
        this.reConfigurationFailure = reConfigurationFail;
    }

    public abstract ParameterDescription getDescription();

    public abstract List<? extends ValueEvent> getValueEvents();

    public String getConfiguredValue() {
        return this.configuredValue;
    }

    public String getValueAt(long date) {
        if (this.hasChanged()) {
            List<? extends ValueEvent> eventList = this.getValueEvents();
            if (eventList == null) {
                return this.configuredValue;
            }
            String lastValue = this.configuredValue;
            for (ValueEvent valueEvent : eventList) {
                if (valueEvent.getTime() >= date) {
                    return lastValue;
                }
                lastValue = valueEvent.getValue();
            }
            return lastValue;
        }
        return this.configuredValue;
    }

    void setValue(String value) {
        this.configuredValue = value;
    }

    public void modifyValue(String value) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("read only value");
        }
        this.setValue(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathObject)) {
            return false;
        }
        PathObject that = (PathObject)o;
        ParameterDescription description = this.getDescription();
        return description.getPath().equals(that.getPath());
    }

    public String toString() {
        return this.getId() + "{" + this.getId() + ": description=" + this.getDescription() + ", value='" + this.configuredValue + '\'' + '}';
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }

    @Override
    public ParameterPath getPath() {
        return this.getDescription().getPath();
    }

    public boolean hasChanged() {
        return this.getValueEvents() != null && !this.getValueEvents().isEmpty();
    }
}

