/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.states.AlertState;

public class RaisedAlertSummary
implements Serializable {
    private static final long serialVersionUID = -9649721904826248L;
    protected final List<RaisedAlertHistory> raisedAlerts = new CopyOnWriteArrayList<RaisedAlertHistory>();

    public RaisedAlertHistory getRaisedAlert(String alertId) {
        for (RaisedAlertHistory raisedAlert : this.raisedAlerts) {
            if (!raisedAlert.getLatestAlert().getAlertId().equals(alertId)) continue;
            return raisedAlert;
        }
        return null;
    }

    public AlertState getAlertState() {
        AlertState base = AlertState.NOMINAL;
        for (RaisedAlertHistory alert : this.raisedAlerts) {
            if (alert.getHighestAlertState().compareTo(base) <= 0) continue;
            base = alert.getHighestAlertState();
        }
        return base;
    }

    public Set<RaisedAlertHistory> getAllRaisedAlertHistories() {
        return new HashSet<RaisedAlertHistory>(this.raisedAlerts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Alarm Summary\n");
        RaisedAlertSummary raisedAlertSummary = this;
        synchronized (raisedAlertSummary) {
            sb.append("Severity : ").append(this.getAlertState()).append("\n");
            for (RaisedAlertHistory alert : this.raisedAlerts) {
                sb.append("Alert: ").append(alert.getLatestAlert().getAlertId()).append(" instances: ").append(alert.getNumberOfInstances()).append(" severity: ").append(alert.getHighestAlertState()).append("\n");
                for (RaisedAlertInstance instance : alert.getRaisedAlertInstancesList()) {
                    sb.append("\t").append(instance.getDescription()).append(" (").append(instance.getAlertState()).append("@").append(instance.getTimestamp()).append(")\n");
                }
            }
        }
        return sb.toString();
    }
}

