/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.framework.annotations.ParameterSetter;
import org.lsst.ccs.utilities.conv.TypeConversionException;
import org.lsst.ccs.utilities.conv.TypeUtils;

public abstract class ConfigurableSubsystem
extends Subsystem {
    protected ConfigurationProxy configurationProxy;
    private final Set<String> categories;
    private final ConfigurationState initialState;
    protected final Map<String, ParameterSetter> parameterSetterDictionary;

    public ConfigurableSubsystem(String name, ConfigurationProxy configProxy, ConfigurationState initialState, Map<String, ParameterSetter> parameterSetterDictionary) {
        super(name, AgentInfo.AgentType.WORKER);
        this.configurationProxy = configProxy;
        this.categories = configProxy.getCategorySet();
        this.initialState = initialState;
        this.parameterSetterDictionary = parameterSetterDictionary;
        configProxy.writeMissingDefaultConfigs();
    }

    public String getTag() {
        return this.configurationProxy.getTagName();
    }

    public ConfigurationProxy getConfigurationProxy() {
        return this.configurationProxy;
    }

    protected void setConfigurationProxy(ConfigurationProxy configurationProxy) {
        this.configurationProxy = configurationProxy;
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION)
    public final void saveAllChanges() throws ConfigurationServiceException {
        this.saveChangesForCategoriesAsInternal(this.configurationProxy.getTaggedCategoriesForCats(this.categories));
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveChangesForCategories(String ... categories) throws ConfigurationServiceException {
        this.saveChangesForCategoriesAsInternal(this.configurationProxy.getTaggedCategoriesForCats(ConfigUtils.parseCategories(this.categories, categories)));
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public final void saveChangesForCategoriesAs(String ... taggedCategories) throws ConfigurationServiceException {
        this.saveChangesForCategoriesAsInternal(this.parseConfigurationString(taggedCategories));
    }

    private void saveChangesForCategoriesAsInternal(Map<String, String> taggedCategories) throws ConfigurationServiceException {
        if (taggedCategories.isEmpty()) {
            return;
        }
        String message = "";
        ConfigurationServiceException exc = null;
        try {
            this.configurationProxy.saveChangesForCategoriesAs(taggedCategories);
        }
        catch (ConfigurationServiceException ex) {
            exc = ex;
            message = ex.getMessage();
        }
        this.updateStateAndSendStatusConfigurationInfo(message, Collections.emptySet());
        if (exc != null) {
            throw exc;
        }
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION)
    public void dropAllChanges() throws Exception {
        this.dropChangesInternal(this.categories);
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void dropChangesForCategories(String ... categories) throws Exception {
        this.dropChangesInternal(ConfigUtils.parseCategories(this.categories, categories));
    }

    private void dropChangesInternal(Set<String> categoriesSet) throws ConfigurationServiceException, TypeConversionException {
        this.dropAllSubmittedChanges();
        Map<String, Properties> changes = this.configurationProxy.loadCategories(this.configurationProxy.getTaggedCategoriesForCats(categoriesSet));
        for (Map.Entry<String, Properties> changesForComponent : changes.entrySet()) {
            for (String parameterName : changesForComponent.getValue().stringPropertyNames()) {
                this.submitChange(changesForComponent.getKey(), parameterName, changesForComponent.getValue().getProperty(parameterName));
            }
        }
        this.validateBulkChanges();
        Set<ParameterPath> processedParms = this.bulkChange();
        this.configurationProxy.saveModifications(this.configurationProxy.getTaggedCategoriesForCats(categoriesSet));
        this.updateStateAndSendStatusConfigurationInfo("", processedParms);
    }

    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration(String ... taggedCategories) throws ConfigurationServiceException, Exception {
        this.loadCategoriesInternal(ConfigUtils.parseConfigurationStringWithDefaults(this.categories, taggedCategories));
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void loadCategories(String ... taggedCategories) throws ConfigurationServiceException, Exception {
        if (taggedCategories.length == 0) {
            return;
        }
        this.loadCategoriesInternal(this.parseConfigurationString(taggedCategories));
    }

    private void loadCategoriesInternal(Map<String, String> categoryProfile) throws ConfigurationServiceException, TypeConversionException {
        this.dropAllSubmittedChanges();
        Map<String, Properties> changes = this.configurationProxy.loadCategories(categoryProfile);
        for (Map.Entry<String, Properties> changesForComponent : changes.entrySet()) {
            for (String parameterName : changesForComponent.getValue().stringPropertyNames()) {
                this.submitChange(changesForComponent.getKey(), parameterName, changesForComponent.getValue().getProperty(parameterName));
            }
        }
        this.validateBulkChanges();
        Set<ParameterPath> processedParms = this.bulkChange();
        this.configurationProxy.saveModifications(categoryProfile);
        this.updateStateAndSendStatusConfigurationInfo("", processedParms);
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.CONFIGURATION)
    public ConfigurationInfo getConfigurationInfo() {
        return this.configurationProxy.buildConfigurationInfo((ConfigurationState)this.getState(ConfigurationState.class), Collections.emptySet());
    }

    private Map<String, String> parseConfigurationString(String ... taggedCategories) {
        return ConfigUtils.parseConfigurationString(this.categories, taggedCategories);
    }

    @Command(description="Submits a single change to be processed immediately", type=Command.CommandType.CONFIGURATION)
    public void change(String componentName, String parameterName, Object value) throws Exception {
        if (!this.configurationProxy.isParameterConfigurable(componentName, parameterName).booleanValue()) {
            throw new IllegalArgumentException("no such parameter : " + componentName + "//" + parameterName);
        }
        ParameterSetter parmSetter = this.parameterSetterDictionary.get(componentName);
        this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURING});
        parmSetter.invokeSetSingleParameter(parameterName, value, this.configurationProxy.getCurrentValuesForComponent(componentName, Collections.emptySet()), this.getState().isInState((Enum)PhaseState.OPERATIONAL));
        this.configurationProxy.notifyParameterChange(componentName, parameterName, TypeUtils.stringify((Object)value));
        HashSet<ParameterPath> processedParms = new HashSet<ParameterPath>();
        processedParms.add(new ParameterPath(componentName, "", parameterName));
        this.updateStateAndSendStatusConfigurationInfo("", processedParms);
    }

    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION)
    public void submitChange(String componentName, String parameterName, Object value) throws TypeConversionException {
        if (!this.configurationProxy.isParameterConfigurable(componentName, parameterName).booleanValue()) {
            throw new IllegalArgumentException("no such parameter : " + componentName + "//" + parameterName);
        }
        this.parameterSetterDictionary.get(componentName).submitChange(parameterName, value);
    }

    @Command(description="processes the bulk change", type=Command.CommandType.CONFIGURATION)
    public void commitBulkChange() {
    }

    protected abstract void validateBulkChanges();

    protected abstract Set<ParameterPath> bulkChange();

    @Deprecated
    @Command(description="Drops the submitted changes", type=Command.CommandType.CONFIGURATION)
    public void dropBulkChange() {
        for (ParameterSetter parmSetter : this.parameterSetterDictionary.values()) {
            parmSetter.dropSubmittedChanges();
        }
    }

    @Command(description="Drops the submitted changes for all components", type=Command.CommandType.CONFIGURATION)
    public void dropAllSubmittedChanges() {
        for (ParameterSetter parmSetter : this.parameterSetterDictionary.values()) {
            parmSetter.dropSubmittedChanges();
        }
    }

    @Command(description="Drops the submitted changes for the given component", type=Command.CommandType.CONFIGURATION)
    public void dropSubmittedChangesForComponent(@Argument(description="the component name") String name) {
        this.parameterSetterDictionary.get(name).dropSubmittedChanges();
    }

    public void doStart() {
        ConfigurationInfo configInfo = this.configurationProxy.buildConfigurationInfo(this.initialState, Collections.emptySet());
        this.updateInternalState("", new AgentState[]{this.initialState});
        this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(configInfo, this.getState()));
    }

    protected void updateStateAndSendStatusConfigurationInfo(String message, Set<ParameterPath> recentChanges) {
        ConfigurationState configState = this.configurationProxy.isDirty() ? ConfigurationState.DIRTY : ConfigurationState.CONFIGURED;
        this.updateInternalState(message, new AgentState[]{configState});
        this.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.configurationProxy.buildConfigurationInfo(configState, recentChanges), this.getState()));
    }

    @Command(description="Returns the current submitted changes for the given component", type=Command.CommandType.CONFIGURATION)
    public Map<String, String> getSubmittedChangesForComponent(@Argument(description="the component name") String name) {
        return this.parameterSetterDictionary.get(name).getSubmittedChanges();
    }

    @Command(description="Returns the current submitted changes for each component", type=Command.CommandType.CONFIGURATION)
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        TreeMap<String, Map<String, String>> res = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, ParameterSetter> entry : this.parameterSetterDictionary.entrySet()) {
            Map submittedChanges = entry.getValue().getSubmittedChanges();
            if (submittedChanges.isEmpty()) continue;
            res.put(entry.getKey(), new TreeMap(submittedChanges));
        }
        return res;
    }
}

