/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusdbUtils {
    public static AnnotationConfiguration ac;
    public static Configuration cfg;
    public static SessionFactory fac;
    protected static Logger log;

    public static SessionFactory getSessionFactory(Properties inputProperties) {
        if (ac == null) {
            ac = new AnnotationConfiguration();
        }
        if (cfg == null) {
            String hibernateConfigFile = System.getProperty("org.lsst.ccs.localdb.hibernate.config.file", "hibernate-tm.cfg.xml");
            String propertiesFile = System.getProperty("org.lsst.ccs.localdb.hibernate.properties.file", "statusPersister.properties");
            String configFileFullPath = BootstrapResourceUtils.getPathOfResource((String)hibernateConfigFile);
            log.info((Object)("hibernate config from " + configFileFullPath));
            try {
                cfg = ac.configure(new URL("file://" + configFileFullPath));
            }
            catch (MalformedURLException ex) {
                log.severe((Object)ex);
                throw new RuntimeException("Could not configur Hibernate", ex);
            }
            log.info((Object)("hibernate properties from " + propertiesFile));
            Properties cfgProps = new Properties();
            try {
                cfgProps.load(BootstrapResourceUtils.getBootstrapPropertiesInputStream((String)propertiesFile, StatusdbUtils.class));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load Hibernate properties", ioe);
            }
            if (inputProperties != null) {
                cfg = cfg.addProperties(inputProperties);
            }
            cfg = cfg.addProperties(cfgProps);
            Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
            Properties finalP = cfg.getProperties();
            log.debug((Object)"*** Working with connection properties ");
            for (Object key : finalP.keySet()) {
                String skey = (String)key;
                if (!skey.contains("connection")) continue;
                log.debug((Object)(skey + ": " + finalP.getProperty(skey)));
            }
            log.debug((Object)"*********************************");
        }
        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }
        return fac;
    }

    static {
        log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    }
}

