/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.jython;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleResult;

public final class JythonConsoleSocketConnection {
    private final Socket consoleSocketConnection;
    private final PrintWriter out;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private PrintStream print = null;

    JythonConsoleSocketConnection(String name) throws UnknownHostException, IOException {
        this(name, 4444, "localhost");
    }

    public JythonConsoleSocketConnection(String name, int port, String host) throws UnknownHostException, IOException {
        this.consoleSocketConnection = new Socket(host, port);
        this.out = new PrintWriter(this.consoleSocketConnection.getOutputStream(), true);
        this.synchLineExecution("initializeInterpreter " + name);
    }

    public void setPrintStream(PrintStream print) {
        this.print = print;
    }

    String synchLineExecution(String line) throws IOException {
        JythonConsoleResult result = this.asynchLineExecution(line);
        return result.getResult();
    }

    String synchFileExecution(String fileName) throws IOException {
        JythonConsoleResult result = this.asynchFileExecution(fileName);
        return result.getResult();
    }

    public String synchFileExecution(InputStream is) throws IOException {
        JythonConsoleResult result = this.asynchFileExecution(is);
        return result.getResult();
    }

    JythonConsoleResult asynchLineExecution(String buffer) throws IOException {
        String contentId = String.valueOf(System.currentTimeMillis());
        JythonConsoleResult result = new JythonConsoleResult(new BufferedReader(new InputStreamReader(this.consoleSocketConnection.getInputStream())), contentId, this.print);
        this.out.println("startContent:" + contentId);
        this.out.println(buffer);
        this.out.println("endContent:" + contentId);
        this.executor.execute(result.getFuture());
        return result;
    }

    public JythonConsoleResult asynchFileExecution(String fileName) throws IOException {
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)fileName);
        if (is == null) {
            is = new FileInputStream(fileName);
        }
        return this.asynchFileExecution(is);
    }

    private JythonConsoleResult asynchFileExecution(InputStream in) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        StringBuilder stringBuffer = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuffer.append(line).append("\n");
        }
        return this.asynchLineExecution(stringBuffer.toString());
    }

    public void close() throws IOException {
        this.consoleSocketConnection.close();
    }

    public static void main(String[] arg) throws Exception {
        JythonConsoleSocketConnection connection = new JythonConsoleSocketConnection("ABC");
        Thread.sleep(5000L);
        connection.close();
    }
}

