/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jline.console.ConsoleReader;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.BusCommandSet;
import org.lsst.ccs.subsystem.shell.SynchronousCommandInvoker;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleSocketConnection;

public class ConsoleCommandShell
implements AgentPresenceListener {
    private final AgentMessagingLayer messagingAccess;
    private final RouteSelectionCommandSet rsc;
    private final CompositeCommandSet ccs;
    private final SynchronousCommandInvoker sci;
    private static final int timeoutMillis = 10000;
    private final Map<String, RoutingCommandSet> routes = new LinkedHashMap<String, RoutingCommandSet>();
    private JythonConsoleSocketConnection jythonConsoleSocketConnection = null;

    ConsoleCommandShell(AgentMessagingLayer messagingAccess) {
        this.messagingAccess = messagingAccess;
        this.sci = new SynchronousCommandInvoker(new ConcurrentMessagingUtils(messagingAccess), 10000);
        CommandSetBuilder builder = new CommandSetBuilder();
        this.ccs = new CompositeCommandSet();
        this.ccs.add(builder.buildCommandSet((Object)new BusMasterCommands()));
        this.rsc = new RouteSelectionCommandSet(this.ccs);
    }

    void init() {
        AgentPresenceManager apMan = this.messagingAccess.getAgentPresenceManager();
        apMan.addAgentPresenceListener((AgentPresenceListener)this);
    }

    public CompositeCommandSet getConsoleCommandSet() {
        return this.rsc;
    }

    public void connecting(AgentInfo agent) {
        if (!(agent.getType().equals((Object)AgentInfo.AgentType.LISTENER) || agent.getType().equals((Object)AgentInfo.AgentType.CONSOLE) || this.routes.containsKey(agent.getName()))) {
            AddSubsystem add = new AddSubsystem(agent.getName());
            Thread t = new Thread(add);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnecting(AgentInfo agent) {
        String agentName = agent.getName();
        ConsoleCommandShell consoleCommandShell = this;
        synchronized (consoleCommandShell) {
            Iterator<Map.Entry<String, RoutingCommandSet>> it = this.routes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, RoutingCommandSet> e = it.next();
                String routeName = e.getKey();
                if (!routeName.equals(agentName) && !routeName.startsWith(agentName + "/")) continue;
                this.ccs.remove((CommandSet)e.getValue());
                it.remove();
            }
        }
    }

    private List<String> availableSubsystems() {
        List agents = this.messagingAccess.getAgentPresenceManager().listConnectedAgents(0);
        return agents.stream().map(org.lsst.ccs.bus.messages.AgentInfo::getName).collect(Collectors.toList());
    }

    synchronized Map<String, RoutingCommandSet> getRoutes() {
        return this.routes;
    }

    public static JLineShell createJLineShell(AgentMessagingLayer messagingAccess, ConsoleReader reader) throws IOException {
        ConsoleCommandShell comShell = new ConsoleCommandShell(messagingAccess);
        comShell.init();
        return new JLineShell((CommandSet)comShell.getConsoleCommandSet(), reader, "${target} ccs>");
    }

    public static void main(String[] argv) throws Exception {
        BusMaster busMaster = new BusMaster("console");
        busMaster.start();
        ConsoleCommandShell comShell = new ConsoleCommandShell(busMaster.getMessagingAccess());
        comShell.init();
        JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        shell.run();
        System.exit(0);
    }

    private class AddSubsystem
    implements Runnable {
        private final String agentName;

        AddSubsystem(String name) {
            this.agentName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CommandRequest getDictionaryCommand = new CommandRequest(this.agentName, "getDictionaries");
                HashMap dictionaries = (HashMap)ConsoleCommandShell.this.sci.invoke(getDictionaryCommand, 10000);
                ConsoleCommandShell consoleCommandShell = ConsoleCommandShell.this;
                synchronized (consoleCommandShell) {
                    for (String path : dictionaries.keySet()) {
                        int first = path.indexOf("/");
                        int last = path.lastIndexOf("/");
                        String name = path;
                        if (first != last) {
                            name = path.substring(0, first) + path.substring(last);
                        }
                        this.addDictionary(name, path, (Dictionary)dictionaries.get(path));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void addDictionary(String routeName, String name, Dictionary dictionary) {
            if (ConsoleCommandShell.this.routes.containsKey(routeName)) {
                throw new RuntimeException("Error: Route " + routeName + " already exist");
            }
            RoutingCommandSet crcs = new RoutingCommandSet(routeName, (CommandSet)new BusCommandSet(ConsoleCommandShell.this.sci, name, dictionary));
            ConsoleCommandShell.this.ccs.add((CommandSet)crcs);
            ConsoleCommandShell.this.routes.put(routeName, crcs);
        }
    }

    public class BusMasterCommands {
        @Command(name="listSubsystems", description="List the subsystems on the CCS buses", alias="ls")
        public List<String> listSubsystems() {
            return ConsoleCommandShell.this.availableSubsystems();
        }

        @Command(description="Set timeout for future command sent on CCS bus")
        public void set(@Argument(name="item") TimeoutEnum what, @Argument(name="value", defaultValue="10000") int timeoutMillis) {
            ConsoleCommandShell.this.sci.setTimeoutMillis(timeoutMillis);
        }

        @Command(description="Get the timeout parameter")
        public int get(@Argument(name="item") TimeoutEnum what) {
            return ConsoleCommandShell.this.sci.getTimeoutMillis();
        }

        @Command(description="Execute a Jython script")
        public void executeScript(@Argument(name="scriptPath") String scriptPath) throws IOException {
            JythonScriptExecutorUtils.executeScript(scriptPath);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void connectToJythonConsole(@Argument(name="host", defaultValue="localhost") String host, @Argument(name="port", defaultValue="4444") int port) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                throw new RuntimeException("There is already a connection established. There can be only one! Please \"closeConnectionWithJythonConsole\" before opening a new one.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection = new JythonConsoleSocketConnection("CommandShellConnection_" + System.currentTimeMillis(), port, host);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void submitScript(@Argument(name="scriptPath") String scriptPath) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("No connection was established with a JythonConsole. Please invoke \"connectToJythonConsole\" first");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.asynchFileExecution(scriptPath);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter")
        public void closeConnectionWithJythonConsole() throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("There is open connection to a JythonConsole.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.close();
            ConsoleCommandShell.this.jythonConsoleSocketConnection = null;
        }
    }

    public static enum TimeoutEnum {
        TIMEOUT;

    }
}

