/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.subsystem.shell.SynchronousCommandInvoker;

class BusCommandSet
implements CommandSet {
    private final String dictionaryPath;
    private final Dictionary dict;
    private final SynchronousCommandInvoker sci;

    BusCommandSet(SynchronousCommandInvoker sci, String dictionaryPath, Dictionary dict) {
        this.sci = sci;
        this.dictionaryPath = dictionaryPath;
        this.dict = dict;
    }

    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    public Object invoke(BasicCommand bc) throws CommandInvocationException, CommandArgumentMatchException {
        DictionaryCommand findCommand = this.dict.findCommand(bc);
        if (findCommand == null) {
            throw new CommandInvocationException("No handler found for command %s with %d arguments", new Object[]{bc.getCommand(), bc.getArgumentCount()});
        }
        CommandRequest basicCommandBusMessage = new CommandRequest(this.dictionaryPath, bc);
        try {
            return this.sci.invoke(basicCommandBusMessage);
        }
        catch (Exception ex) {
            throw new CommandInvocationException("Error dispatching command: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

