/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.lsst.ccs.bus.messages.CommandMessage;

@Entity
@Table(name="commandmessagedata")
public class CommandMessageData
implements Serializable {
    private static final long serialVersionUID = 49230942038176402L;
    private String type;
    private String destination;
    private String correlId;
    private String content;
    private String origin;
    private long id;
    private long tstamp;

    public CommandMessageData() {
    }

    public CommandMessageData(CommandMessage cmd) {
        this.type = cmd.getClass().getSimpleName();
        this.origin = cmd.getOriginAgentInfo().getName();
        this.destination = cmd.getDestination();
        this.correlId = cmd.getCorrelationId().toString();
        this.content = (String)cmd.getEncodedData();
        this.tstamp = cmd.getTimeStamp();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getCorrelId() {
        return this.correlId;
    }

    public void setCorrelId(String correlId) {
        this.correlId = correlId;
    }

    @Lob
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public long getTstamp() {
        return this.tstamp;
    }

    public void setTstamp(long tstamp) {
        this.tstamp = tstamp;
    }
}

