/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.lsst.gruth.jutils.CallBuilders;
import org.lsst.gruth.jutils.IndirectMap;
import org.lsst.gruth.jutils.PackCst;
import org.lsst.gruth.utils.Tracer;

public class ComponentNode<T extends ComponentNode<T>>
implements Serializable {
    protected IndirectMap<String, Object> nodeDict;
    protected boolean root;
    protected boolean orphan;
    protected ComponentNode calls;
    protected String key;
    protected T parent;
    protected ArrayList<T> children;
    protected String name;
    protected String simpleDescription;
    protected Object realValue;
    protected Map attributes;

    public IndirectMap getNodeDict() {
        return this.nodeDict;
    }

    @Deprecated
    public void setNodeDict(IndirectMap<String, Object> registry) {
        this.nodeDict = registry;
    }

    protected void checkDict(T parent, Object name, Map attributes) {
        IndirectHash<String, Object> dict;
        if (parent == null) {
            dict = new IndirectHash<String, Object>();
            this.root = true;
        } else {
            dict = ((ComponentNode)parent).getNodeDict();
        }
        this.setDict(dict, name, attributes);
    }

    protected void setDict(IndirectMap<String, Object> registry, Object name, Map attributes) {
        Object valName;
        String keyStr = String.valueOf(name);
        if (attributes != null && (valName = attributes.get("name")) != null) {
            keyStr = String.valueOf(valName);
        }
        this.key = keyStr;
        this.name = keyStr;
        registry.put(keyStr, this);
        this.nodeDict = registry;
    }

    public ComponentNode(T parent, Object name) {
        this(parent, name, null, null);
    }

    public ComponentNode(T parent, Object name, Object value) {
        this(parent, name, null, value);
    }

    public ComponentNode(T parent, Object name, Map attributes) {
        this(parent, name, attributes, null);
    }

    public ComponentNode(T parent, Object name, Map attributes, Object value) {
        this.parent = parent;
        this.simpleDescription = this.name = String.valueOf(name);
        this.attributes = attributes;
        this.realValue = value;
        this.checkDict(parent, name, attributes);
    }

    protected ComponentNode(IndirectMap<String, Object> registry, Object name, String key, Map attributes, Object value) {
        this.simpleDescription = this.name = String.valueOf(name);
        this.attributes = attributes;
        this.realValue = value;
        this.setDict(registry, name, attributes);
        this.orphan = true;
    }

    public Object calls(Object callDescription) {
        CallBuilders.CallBuilds builder = CallBuilders.getCallBuilder();
        this.calls = builder.buildCalls(this, callDescription);
        return this;
    }

    public ComponentNode setCalls(ComponentNode callsNode) {
        this.calls = callsNode;
        return this;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean isRoot) {
        this.root = isRoot;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public ComponentNode getCalls() {
        return this.calls;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleDescription() {
        return this.simpleDescription;
    }

    public void setSimpleDescription(String simpleDescription) {
        this.simpleDescription = simpleDescription;
    }

    public Object getRealValue() {
        return this.realValue;
    }

    public Object getNodeByName(String name) {
        return this.nodeDict.get(name);
    }

    public Object getIndirect(Object key) {
        Object node = this.nodeDict.get(key);
        if (node instanceof ComponentNode) {
            return ((ComponentNode)node).getRealValue();
        }
        return node;
    }

    public Iterator<String> getAllKeys() {
        return this.nodeDict.keySet().iterator();
    }

    public Iterable<String> getAllNames() {
        Collection col = this.nodeDict.values();
        HashSet<String> res = new HashSet<String>();
        for (Object obj : col) {
            if (!(obj instanceof ComponentNode)) continue;
            res.add(((ComponentNode)obj).getName());
        }
        return res;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getKey() {
        return this.key;
    }

    public ArrayList<T> getChildren() {
        return this.children;
    }

    public void addChild(T child) throws NullPointerException {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (((ComponentNode)child).parent == null) {
            ((ComponentNode)child).root = false;
            if (((ComponentNode)child).nodeDict != null && ((ComponentNode)child).nodeDict != this.nodeDict) {
                this.nodeDict.putAll(((ComponentNode)child).getNodeDict());
                ((ComponentNode)child).nodeDict = this.nodeDict;
            } else {
                ((ComponentNode)child).setDict(this.nodeDict, ((ComponentNode)child).getName(), ((ComponentNode)child).getAttributes());
            }
        } else if (((ComponentNode)child).parent != this) {
            throw new IllegalArgumentException("child added but is part of another node tree");
        }
        this.children.add(child);
    }

    public String toString() {
        String valueString;
        try {
            valueString = String.valueOf(this.realValue);
        }
        catch (Exception exc) {
            valueString = "can't trace value [" + exc + "] ";
        }
        return String.valueOf(String.valueOf(this.name)) + "(" + valueString + "," + String.valueOf(this.attributes) + ") {" + String.valueOf(this.children) + "}";
    }

    public ComponentNode getChildAt(int childIndex) {
        return (ComponentNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public T getParent() {
        return this.parent;
    }

    public int getIndex(ComponentNode node) {
        ComponentNode realNode = node;
        return this.children.indexOf(realNode);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    static class IndirectHash<K, V>
    extends LinkedHashMap<K, V>
    implements IndirectMap<K, V> {
        IndirectHash() {
        }

        @Override
        public Object getIndirect(Object key) {
            Object obj = this.get(key);
            if (obj instanceof ComponentNode) {
                obj = ((ComponentNode)obj).getRealValue();
            }
            Tracer.trace(Tracer.NODE_BUILD, "reference to ", key, " ", obj);
            if (obj == null) {
                PackCst._LOGGER.log(Level.WARNING, "null reference associated to {0}", key);
            }
            return obj;
        }
    }
}

