/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusApplicationLayer;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DestinationsException;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentMessagingLayer {
    private static final List<AgentMessagingLayer> msgAccesses = new CopyOnWriteArrayList<AgentMessagingLayer>();
    private final BusMessageFilter filterMessagesFromThisAgent;
    private final Logger curLogger = Logger.getLogger((String)"org.lsst.ccs.bus");
    private final BusApplicationLayer layer;
    private final AgentInfo agentInfo;

    public static AgentMessagingLayer createInstance(AgentInfo agentInfo) {
        AgentMessagingLayer agentMessagingLayer = new AgentMessagingLayer(agentInfo);
        msgAccesses.add(agentMessagingLayer);
        return agentMessagingLayer;
    }

    AgentMessagingLayer(AgentInfo agentInfo) {
        if (agentInfo == null) {
            throw new RuntimeException("MessagingAccess cannot have null Agent");
        }
        this.agentInfo = agentInfo;
        this.layer = new BusApplicationLayer(agentInfo);
        this.filterMessagesFromThisAgent = BusMessageFilter.messageOrigin(agentInfo.getName()).negate();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public String getAgentName() {
        return this.agentInfo.getName();
    }

    protected BusApplicationLayer getApplicationLayer() {
        return this.layer;
    }

    public void shutdownBusAccess() {
        this.layer.close();
        msgAccesses.remove(this);
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.layer.getAgentPresenceManager();
    }

    public void addLogMessageListener(LogMessageListener listener) {
        this.addLogMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addLogMessageListener(LogMessageListener listener, BusMessageFilter filter) {
        this.layer.addLogListener(listener, filter);
    }

    public void addStatusMessageListener(StatusMessageListener listener) {
        this.addStatusMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addStatusMessageListener(StatusMessageListener listener, BusMessageFilter filter) {
        this.layer.addStatusListener(listener, filter);
    }

    public void addCommandMessageListener(CommandMessageListener listener) {
        this.addCommandMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addCommandMessageListener(CommandMessageListener listener, BusMessageFilter filter) {
        this.layer.addCommandListener(listener, filter);
    }

    public void removeLogMessageListener(LogMessageListener listener) {
        this.layer.removeLogListener(listener);
    }

    public void removeStatusMessageListener(StatusMessageListener listener) {
        this.layer.removeStatusListener(listener);
    }

    public void removeCommandMessageListener(CommandMessageListener listener) {
        this.layer.removeCommandListener(listener);
    }

    public void sendLogMessage(LogMessage msg) {
        msg.setOriginAgentInfo(this.getAgentInfo());
        try {
            this.layer.sendLog(msg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendStatusMessage(StatusMessage msg) {
        msg.setOriginAgentInfo(this.getAgentInfo());
        this.curLogger.finest((Object)("sending status " + msg));
        try {
            this.layer.sendStatus(msg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendCommandRequest(CommandRequest cmd, CommandOriginator originator) {
        cmd.setOriginAgentInfo(this.getAgentInfo());
        try {
            this.layer.sendCommand(cmd, originator);
        }
        catch (IOException e) {
            if (e instanceof DestinationsException) {
                this.curLogger.warn((Object)"destination problem", (Throwable)e);
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
    }

    public void sendCommandReply(CommandReply reply) {
        reply.setOriginAgentInfo(this.getAgentInfo());
        try {
            this.layer.reply(reply);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCommandExecutor(CommandExecutor executor) {
        this.layer.setCommandExecutor(executor);
    }

    static List<AgentMessagingLayer> getMessagingAccesses() {
        return msgAccesses;
    }

    static void printMessagingAccessInfo(AgentMessagingLayer msgAccess) {
        System.out.println("MessagingAccess " + msgAccess.getAgentName());
        BusApplicationLayer layer = msgAccess.getApplicationLayer();
        System.out.println("BusApplicationLayer " + layer);
        BusMessagingLayer messagingLayer = layer.getBusMessagingLayer();
        System.out.println("BusMessagingLayer " + messagingLayer);
        Set<String> localAgents = messagingLayer.getRegisteredLocalAgents();
        System.out.println("Local Agents " + localAgents.size());
        for (String agent : localAgents) {
            System.out.println("\t" + agent);
        }
    }
}

