/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.config.ConfigurationEnvironment;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.description.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.startup.NodeLookup;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.jutils.EffectiveNode;

public class NodeModularSubsystem
extends ConfigurableSubsystem {
    private final ComponentLookupService lookup;
    private final Configurable mainObject;
    private final ArrayList<ViewValue> preOrderComponentList = new ArrayList();
    private final List<ViewValue> preOrderUnmodifiableView = Collections.unmodifiableList(this.preOrderComponentList);

    NodeModularSubsystem(String subsystemName, ConfigurationProxy configurationProxy, EffectiveNode effectiveNode, ConfigurationState initialState) throws Exception {
        super(subsystemName, configurationProxy, initialState);
        this.lookup = new NodeLookup(this, effectiveNode);
        this.realRegisterNodes(effectiveNode);
        this.mainObject = (Configurable)effectiveNode.getRealValue();
        this.doInitComponents();
    }

    protected void updateHeartBeat(StatusHeartBeat s) {
    }

    public ComponentLookupService getLookup() {
        return this.lookup;
    }

    public List<ViewValue> getPreOrderComponentList() {
        return this.preOrderUnmodifiableView;
    }

    private void realRegisterNodes(EffectiveNode node) {
        String key = node.getKey();
        Object value = node.getRealValue();
        this.preOrderComponentList.add(new ViewValue(key, value));
        ArrayList children = node.getChildren();
        if (children != null) {
            for (EffectiveNode child : children) {
                this.realRegisterNodes(child);
            }
        }
        if (value instanceof Configurable) {
            Configurable configurable = (Configurable)value;
            configurable.setEnvironment((Configurable.Environment)new ConfigurationEnvironment(key, configurable, this.getConfigurationProxy(), this.lookup));
        }
    }

    private void doInitComponents() {
        this.mainObject.proceduralWalk(Configurable::init, null);
    }

    public void doStart() {
        super.doStart();
        this.mainObject.proceduralWalk(Configurable::start, null);
    }

    public void postStart() throws HardwareException {
        this.callPostStart(this.mainObject);
    }

    private void callPostStart(Configurable goal) throws HardwareException {
        goal.postStart();
        for (Configurable configurable : goal.listChildren()) {
            this.callPostStart(configurable);
        }
    }

    public void doShutdown() {
        log.fine((Object)("Subsystem " + this.getName() + " shutdown starting"));
        this.mainObject.proceduralWalk(Configurable::shutdownNow, null);
    }

    protected Configurable getCommandDestination(String commandDestination) {
        Configurable configurable = null;
        String configurableName = "main";
        if (commandDestination.contains("/")) {
            configurableName = commandDestination.substring(commandDestination.indexOf("/") + 1);
        }
        if ((configurable = (Configurable)this.lookup.getComponentByName(configurableName)) == null) {
            throw new IllegalArgumentException(" no such configurable " + configurableName + " for command destination");
        }
        return configurable;
    }

    @Command(description="halt", type=Command.CommandType.SIGNAL)
    public void abort() {
        super.abort();
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.HALT));
    }

    @Command(description="halt with expected max delay", type=Command.CommandType.SIGNAL)
    public void abort(long expectedMaxDelay) {
        super.abort();
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.HALT, expectedMaxDelay));
    }

    @Command(description="stops with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        super.stop(expectedMaxDelay);
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.STOP, expectedMaxDelay));
    }

    @Command(description="stops hardware", type=Command.CommandType.ACTION)
    public void stop() throws HardwareException {
        this.stop(Long.MAX_VALUE);
    }

    @Command(description="waits until all the hardware devices are actually stopped", type=Command.CommandType.ACTION)
    public void stopAndWait(long expectedMaxDelay) throws HardwareException, InterruptedException {
        this.stop(expectedMaxDelay);
        int step = 10;
        long fracDelay = expectedMaxDelay / (long)step;
        HardwareException lastExc = null;
        for (int i = 0; i < step; ++i) {
            try {
                Thread.sleep(fracDelay);
                this.checkAllHardwareStopped();
                return;
            }
            catch (HardwareException e) {
                lastExc = e;
                continue;
            }
        }
        throw lastExc;
    }

    public void checkHardware() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        HardwareException[] exc = new HardwareException[]{null};
        mainModule.treeWalk(configurable -> {
            block3: {
                if (configurable instanceof HardwareController) {
                    try {
                        return ((HardwareController)configurable).checkHardware();
                    }
                    catch (HardwareException e) {
                        exc[0] = new HardwareException(configurable.toString() + "not started ", (Throwable)e, exc[0]);
                        if (!e.isFatal()) break block3;
                        return TreeWalkerDiag.STOP;
                    }
                }
            }
            return TreeWalkerDiag.GO;
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void checkAllHardwareStarted() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        HardwareException[] exc = new HardwareException[]{null};
        mainModule.proceduralWalk(configurable -> {
            if (configurable instanceof HardwareController) {
                try {
                    ((HardwareController)configurable).checkStarted();
                }
                catch (HardwareException e) {
                    exc[0] = new HardwareException(configurable.toString() + "not started ", (Throwable)e, exc[0]);
                }
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void checkAllHardwareStopped() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        HardwareException[] exc = new HardwareException[]{null};
        mainModule.proceduralWalk(configurable -> {
            if (configurable instanceof HardwareController) {
                try {
                    ((HardwareController)configurable).checkStopped();
                }
                catch (HardwareException e) {
                    exc[0] = new HardwareException(configurable.toString() + "not started ", (Throwable)e, exc[0]);
                }
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }
}

