/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.lsst.ccs.CCSProxy;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.description.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.utilities.structs.ViewValue;

public class ConfigurationEnvironment
implements Configurable.Environment {
    private static final HashMap<String, Map<String, Method>> METHOD_MAP = new HashMap();
    private final String name;
    private final Object relevantObject;
    private final Map<String, Method> configMethods;
    private final ConfigurationProxy configurationProxy;
    private final ComponentLookupService lookupService;

    public ConfigurationEnvironment(String name, Configurable currentObject, ConfigurationProxy configurationProxy, ComponentLookupService lookupService) {
        this.name = name;
        this.relevantObject = currentObject instanceof CCSProxy ? ((CCSProxy)currentObject).getDelegate() : Objects.requireNonNull(currentObject);
        this.configurationProxy = Objects.requireNonNull(configurationProxy);
        this.lookupService = Objects.requireNonNull(lookupService);
        Class<?> clazz = this.relevantObject.getClass();
        String clazzName = clazz.getName();
        Map<String, Method> confMethods = METHOD_MAP.get(clazzName);
        if (confMethods == null) {
            this.configMethods = new HashMap<String, Method>();
            METHOD_MAP.put(clazzName, this.configMethods);
            for (Method method : clazz.getMethods()) {
                String propertyName;
                String methodName = method.getName();
                ConfigChanger configChanger = method.getAnnotation(ConfigChanger.class);
                if (configChanger == null) continue;
                if (methodName.startsWith("set")) {
                    char firstLetter = methodName.charAt(3);
                    String propertyName2 = Character.toLowerCase(firstLetter) + methodName.substring(4);
                    this.configMethods.put(propertyName2, method);
                }
                if ("".equals(propertyName = configChanger.propertyName())) continue;
                this.configMethods.put(propertyName, method);
            }
        } else {
            this.configMethods = confMethods;
        }
    }

    public void change(String parameterName, Object value) throws Exception {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().singleChange(this.name, parameterName, value);
    }

    public void submitChange(String parameterName, Object value) {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().submitChange(this.name, parameterName, value);
    }

    @Deprecated
    public void register(String configurationName) throws ConfigurationServiceException {
        this.saveChangesForCategoriesAs(configurationName);
    }

    @Deprecated
    public void saveConfiguration() throws ConfigurationServiceException {
        this.saveAllChanges();
    }

    @Deprecated
    public void saveConfiguration(String configName) throws ConfigurationServiceException {
        this.saveChangesForCategoriesAs(configName);
    }

    public void saveAllChanges() throws ConfigurationServiceException {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().saveAllChanges();
    }

    public void saveChangesForCategories(String ... categories) throws ConfigurationServiceException {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().saveChangesForCategories(categories);
    }

    public void saveChangesForCategoriesAs(String ... taggedCategories) throws ConfigurationServiceException {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().saveChangesForCategoriesAs(taggedCategories);
    }

    public void dropAllChanges() throws Exception {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().dropAllChanges();
    }

    public void dropChangesForCategories(String ... categories) throws Exception {
        if (!this.isInEngineeringMode()) {
            throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
        }
        this.getConfigurableSubsystem().dropChangesForCategories(categories);
    }

    private boolean isInEngineeringMode() {
        return this.getSubsystem().get().isInEngineeringMode();
    }

    public ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
        ViewValue data = this.configurationProxy.checkForParameterChange(this.name, parameterName, value);
        return data;
    }

    public void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
        this.configurationProxy.notifyUncheckedParameterChange(this.name, parameterName, value);
    }

    public void notifyChange(String parameterName, String value) throws Exception {
        this.configurationProxy.notifyParameterChange(this.name, parameterName, value);
    }

    public Object getComponentByName(String name) {
        return this.lookupService.getComponentByName(name);
    }

    public void alias(String name) {
        this.lookupService.aliasObject(name, this.relevantObject);
    }

    public <T> LinkedHashMap<String, T> getChildren(Class<T> classFilter) {
        Objects.requireNonNull(classFilter);
        return this.lookupService.getChildren(this.name, classFilter);
    }

    public List<Configurable> listChildren() {
        return this.lookupService.listChildren(this.name);
    }

    public Map.Entry<String, Object> getParent() {
        return this.lookupService.getParent(this.name);
    }

    public String getNameOfComponent() {
        return this.name;
    }

    public Object getRelevantObject() {
        return this.relevantObject;
    }

    @Deprecated
    public Map<String, Method> getConfigMethodsOfComponent() {
        return this.configMethods;
    }

    public Method getConfigMethodOfComponent(String parameterName) {
        Method res = this.configMethods.get(parameterName);
        if (res == null) {
            throw new IllegalArgumentException(" no such config property :" + parameterName);
        }
        return res;
    }

    public Optional<Subsystem> getSubsystem() {
        return this.lookupService.getSubsystem();
    }

    private ConfigurableSubsystem getConfigurableSubsystem() {
        return (ConfigurableSubsystem)this.getSubsystem().get();
    }

    public void dropBulkChange() {
        this.getConfigurableSubsystem().dropBulkChange();
    }
}

