/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.PathObject;
import org.lsst.ccs.config.SubsystemDescription;

@MappedSuperclass
public abstract class ConfigProfile
implements Serializable {
    private long startTimestamp;
    private long endTimestamp = PackCst.STILL_VALID;
    private String subsystemName;
    private String tag;
    private String categoryName;
    private String configNameForCategory;
    private boolean changingStaticData;
    private int level = 5;
    private String remarks;
    private long previousConfigID;

    protected ConfigProfile() {
    }

    protected ConfigProfile(String subsystemName, String tag, int level, String categoryName, String configName) {
        this.subsystemName = subsystemName;
        this.tag = tag;
        this.level = level;
        this.categoryName = categoryName;
        this.configNameForCategory = configName;
    }

    public abstract long getId();

    protected abstract void setId(long var1);

    public abstract SubsystemDescription getSubsystemDescription();

    public abstract Set<? extends ParameterConfiguration> getModifiedParameters();

    public abstract ParameterConfiguration temporaryChangeConfigurationValue(String var1, long var2, String var4, boolean var5);

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    @Column(name="name")
    @Access(value=AccessType.PROPERTY)
    public String getName() {
        return this.getCategoryName() + ":" + this.getConfigName();
    }

    public void setName(String name) {
    }

    public boolean isChangingStaticData() {
        return this.changingStaticData;
    }

    void setChangingStaticData(boolean changingStaticData) {
        this.changingStaticData = changingStaticData;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    public void setSubsystemName(String subsystemName) {
        if (this.subsystemName == null || "".equals(this.subsystemName)) {
            this.subsystemName = subsystemName;
        }
    }

    public String getTag() {
        return this.tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getConfigName() {
        return this.configNameForCategory;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    protected void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public int getLevel() {
        return this.level;
    }

    void setLevel(int level) {
        this.level = level;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public long getPreviousConfigID() {
        return this.previousConfigID;
    }

    void setPreviousConfigID(long previousConfigID) {
        this.previousConfigID = previousConfigID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigProfile)) {
            return false;
        }
        ConfigProfile that = (ConfigProfile)o;
        if (this.getId() != that.getId()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        String tag = this.getTag();
        return !(tag != null ? !tag.equals(that.getTag()) : that.getTag() != null);
    }

    public int hashCode() {
        long id = this.getId();
        int result = (int)(id ^ id >>> 32);
        result = 31 * result + this.getName().hashCode();
        String tag = this.getTag();
        result = 31 * result + (tag != null ? tag.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{id=" + this.getId() + "; name=" + this.getName() + "(" + this.getSubsystemDescription().getId() + ")" + ";configurations=" + this.getModifiedParameters() + '}';
    }

    protected ParameterConfiguration fetch(PathObject path) {
        for (ParameterConfiguration parameterConfiguration : this.getModifiedParameters()) {
            if (!parameterConfiguration.getPath().equals(path.getPath())) continue;
            return parameterConfiguration;
        }
        return null;
    }

    public List<ParameterConfiguration> getAllReconfigurationFailures() {
        ArrayList<ParameterConfiguration> res = new ArrayList<ParameterConfiguration>();
        for (ParameterConfiguration parameterConfiguration : this.getModifiedParameters()) {
            if (parameterConfiguration.getReConfigurationFailure() == null) continue;
            res.add(parameterConfiguration);
        }
        return res;
    }

    public List<String> reportFailures() {
        ArrayList<String> res = new ArrayList<String>();
        for (ParameterConfiguration config : this.getAllReconfigurationFailures()) {
            res.add(config.getPath() + " : " + config.getReConfigurationFailure());
        }
        return res;
    }

    public abstract void addParameterConfiguration(String var1, String var2);

    public abstract void addParameterConfigurations(ParameterConfiguration ... var1);

    public abstract void removeParameterConfigurations(ParameterConfiguration ... var1);

    public String getValueAt(String parameterPath, long date) {
        if (parameterPath == null) {
            return null;
        }
        ParameterPath path = ParameterPath.valueOf(parameterPath);
        return this.getValueAt(path, date);
    }

    public String getValueAt(ParameterPath path, long date) {
        ParameterConfiguration parmConfig = this.fetch(path);
        if (parmConfig == null) {
            SubsystemDescription subsystemDescription = this.getSubsystemDescription();
            ParameterDescription description = subsystemDescription.fetch(path);
            if (description != null) {
                return description.getParameterBase().getDefaultValue();
            }
            return null;
        }
        return parmConfig.getValueAt(date);
    }

    public abstract boolean isDirty();
}

