/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote.scripts;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.DescriptionResult;
import org.lsst.ccs.config.remote.scripts.ConfigurationBusClient;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.utilities.jars.CommonResources;
import org.lsst.gruth.nodes.Utils;

public class RegisterDescriptionFromFile {
    ConfigurationBusClient busClient;

    public RegisterDescriptionFromFile(ConfigurationBusClient busClient) {
        this.busClient = busClient;
    }

    public DescriptionResult register(String pathName) throws Exception {
        Object componentNode = null;
        NamesAndTag namesAndTag = ConfigUtils.namesFromPath(pathName);
        String subsystemName = namesAndTag.getSubsystemName();
        String configName = namesAndTag.getConfigName();
        String tag = namesAndTag.getTag();
        InputStream is = CommonResources.getInput(RegisterDescriptionFromFile.class, (String)pathName);
        if (pathName.endsWith(".ser")) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
            componentNode = (Serializable)ois.readObject();
        } else if (pathName.endsWith(".groovy")) {
            componentNode = Utils.getComponentNodeFromGroovy((InputStream)is, (String)"ISO-8859-1");
        }
        SubsystemDescription description = Factories.createRawSubsystemDescription(subsystemName, tag, (Serializable)componentNode, DataFlavour.PURE_OBJECT_TREE);
        Object res = this.busClient.invoke("registerSubsystemDescription", description);
        return (DescriptionResult)res;
    }
}

