/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.Collection;
import java.util.EnumMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.MessageListener;

public class MessagingAccessLayer {
    private final String name;
    private final EnumMap<Bus, BusAccess> busAccesses = new EnumMap(Bus.class);

    public MessagingAccessLayer(String name, BusAccess ... buses) {
        this.name = name;
        for (BusAccess busAccess : buses) {
            this.busAccesses.put(busAccess.getBus(), busAccess);
        }
    }

    public String getName() {
        return this.name;
    }

    public Collection<BusAccess> getBusAccesses() {
        return this.busAccesses.values();
    }

    public BusAccess getBusAccess(Bus bus) {
        return this.busAccesses.get(bus);
    }

    public static abstract class StatusBusAccess
    extends BusAccess<StatusMessage> {
        public StatusBusAccess() {
            super(Bus.STATUS);
        }

        public abstract void processDisconnectionSuspicion(String var1);

        public abstract void processAnormalEvent(Exception var1);
    }

    public static class BusAccess<T extends BusMessage> {
        private final ConcurrentHashMap<MessageListener, BusMessageForwarder> forwarderMap = new ConcurrentHashMap();
        private final CopyOnWriteArrayList<BusMessageForwarder> forwarderList = new CopyOnWriteArrayList();
        private final Bus bus;

        public BusAccess(Bus bus) {
            this.bus = bus;
        }

        public Bus getBus() {
            return this.bus;
        }

        public void processBusMessage(T message) {
            this.forwarderList.forEach(f -> f.update(message));
        }

        public void addForwarder(MessageListener l, BusMessageForwarder forwarder) {
            this.forwarderMap.put(l, forwarder);
            this.forwarderList.add(forwarder);
        }

        public void removeForwarder(MessageListener l) {
            BusMessageForwarder busForwarder = this.forwarderMap.remove(l);
            if (busForwarder != null) {
                this.forwarderList.remove(busForwarder);
            }
        }
    }
}

