/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurableProxy;
import org.lsst.ccs.framework.ConfigurableSubsystem;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.utilities.functions.MutableReference;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class Module
extends Observable
implements Observer,
Configurable,
SignalHandler {
    protected Configurable.Environment environment;
    @Deprecated
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.framework");
    protected String name;
    private List<Observable> observables = new ArrayList<Observable>();
    protected int nObserverThreads = 1;
    protected int tickMillis = -1;
    TimerTask timerTask;
    ExecutorService exec;
    Timer timer;
    private static Observable[] model = new Observable[0];

    public Module() {
    }

    public Module(int tickMillis) {
        this.tickMillis = tickMillis;
    }

    public Module(String name, int tickMillis) {
        this.name = name;
        this.tickMillis = tickMillis;
    }

    public Module(String name) {
        this(name, -1);
    }

    @Override
    public String getName() {
        if (this.name == null && this.environment != null) {
            this.name = this.environment.getNameOfComponent();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void alias(String alias) {
        if (this.environment != null) {
            this.environment.alias(alias);
        }
    }

    @Override
    public Configurable.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Configurable.Environment environment) {
        this.environment = environment;
    }

    public void setObservables(List<Observable> l) {
        this.observables.addAll(l);
    }

    public void listens(Observable ... observs) {
        for (Observable observable : observs) {
            this.observables.add(observable);
        }
    }

    public List<Observable> getObservables() {
        return this.observables;
    }

    @ConfigChanger(argNames={"tickInterval"})
    public void setTickMillis(int tickMillis) {
        int old = this.tickMillis;
        this.tickMillis = tickMillis;
        if (this.timerTask != null && this.timer != null && tickMillis != old) {
            this.timerTask.cancel();
            if (tickMillis > 0) {
                this.timerTask = new TimerTask(){
                    CurrentCommandContext context;
                    {
                        this.context = new CurrentCommandContext("timer_" + Module.this.getName(), "tick");
                    }

                    @Override
                    public void run() {
                        Subsystem.LOCAL_EXECUTION_INFO.set(this.context);
                        Module.this.tick();
                    }
                };
                this.timer.scheduleAtFixedRate(this.timerTask, 0L, (long)tickMillis);
            }
        }
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setNObserverThreads(int observerThreads) {
        this.nObserverThreads = observerThreads;
    }

    public int getNObserverThreads() {
        return this.nObserverThreads;
    }

    @Override
    public final void init() {
        this.injectResources();
        if (this.getParentObject() == null) {
            this.proceduralWalk(configurable -> {
                Object obj = configurable;
                if (configurable instanceof ConfigurableProxy) {
                    obj = ((ConfigurableProxy)configurable).getDelegate();
                }
                CommandSet commandSet = new CommandSetBuilder().buildCommandSet(obj);
                String fullPath = configurable.getFullPath();
                this.getSubsystem().addCommandSet(fullPath, commandSet);
            }, configurable -> {});
        }
        this.initModule();
        for (Observable o : this.observables) {
            o.addObserver(this);
        }
        this.exec = Executors.newFixedThreadPool(this.nObserverThreads, new ThreadFactory(){
            int number;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "update-" + this.number++);
            }
        });
    }

    public void initModule() {
    }

    @Override
    public Subsystem getSubsystem() {
        Optional<ConfigurableSubsystem> opt = this.getEnvironment().getSubsystem();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    public Module getModule(String moduleName) {
        Object obj = this.getComponentByName(moduleName);
        if (obj instanceof Module) {
            return (Module)obj;
        }
        return null;
    }

    @Override
    public void postStart() throws HardwareException {
        this.startTicking();
    }

    public void startTicking() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer("timer_" + this.getName());
        this.timerTask = new TimerTask(){
            CurrentCommandContext context;
            {
                this.context = new CurrentCommandContext("timer_" + Module.this.getName(), "tick");
            }

            @Override
            public void run() {
                Subsystem.LOCAL_EXECUTION_INFO.set(this.context);
                Module.this.tick();
            }
        };
        if (this.tickMillis > 0) {
            this.timer.scheduleAtFixedRate(this.timerTask, 0L, (long)this.tickMillis);
        }
    }

    @Override
    public void update(final Observable o, final Object arg) {
        if (!(arg instanceof ValueUpdate)) {
            log.error((Object)("update called with arg not a ValueUpdate: " + arg));
            return;
        }
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                Module.this.processUpdate(o, (ValueUpdate)arg);
            }
        });
    }

    public void processUpdate(Observable source, ValueUpdate update) {
    }

    public void tick() {
    }

    @Override
    public void shutdownNow() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }

    @Override
    public TreeWalkerDiag signal(Signal sig) {
        return TreeWalkerDiag.GO;
    }

    @Command(description="will propagate signal to Module and its children ", type=Command.CommandType.SIGNAL)
    public void sendSignal(String signalString) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel);
        this.percolateSignal(signal);
    }

    @Command(description="will propagate signal to Module and its children with  an expected maximum delay", type=Command.CommandType.SIGNAL)
    public void sendSignalWithTimeLimit(String signalString, long expectedMaxDelay) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel, expectedMaxDelay);
        this.percolateSignal(signal);
    }

    public void percolateSignal(Signal signal) {
        this.treeWalk(configurable -> {
            if (configurable instanceof SignalHandler) {
                SignalHandler signalHandler = (SignalHandler)((Object)configurable);
                return signalHandler.signal(signal);
            }
            return TreeWalkerDiag.GO;
        }, null);
    }

    @Command(description="publishes a tree of component names", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public TreeBranch<String> getComponentTree() {
        MutableReference tree = new MutableReference();
        this.proceduralWalk(configurable -> {
            mutableReference.reference = new TreeBranch((TreeBranch)mutableReference.reference, (Serializable)((Object)configurable.getName()));
        }, configurable -> {
            TreeBranch parent = ((TreeBranch)mutableReference.reference).getRealParent();
            if (parent != null) {
                mutableReference.reference = parent;
            }
        });
        return (TreeBranch)tree.reference;
    }

    public class ValueUpdate {
        String name;
        Object value;
        long timeStamp = System.currentTimeMillis();

        public ValueUpdate(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public ValueUpdate(String name, Object value, long tStamp) {
            this.name = name;
            this.value = value;
            this.timeStamp = tStamp;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

