/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.ParameterFilter;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.framework.ConfigurableSubsystem;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.startup.MainDescriptiveNode;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.utilities.tracers.Tracer;
import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.jutils.EffectiveNode;
import org.lsst.gruth.nodes.ComponentFactory;
import org.lsst.gruth.nodes.Utils;

public class BootUtils {
    static String userName;
    static String version;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static DescriptiveNode getDescriptiveNode(String pathName) throws Exception {
        InputStream is;
        DescriptiveNode componentNode = null;
        if (pathName.endsWith(".ser")) {
            is = BootstrapResourceUtils.getBootstrapResource((String)pathName, BootUtils.class);
            if (is != null) {
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
                componentNode = (DescriptiveNode)ois.readObject();
            }
        } else {
            is = BootstrapResourceUtils.getBootstrapResource((String)(pathName + (pathName.endsWith(".groovy") ? "" : ".groovy")), BootUtils.class);
            if (is != null) {
                componentNode = Utils.getComponentNodeFromGroovy((InputStream)is, (String)"ISO-8859-1");
            }
        }
        if (is == null) {
            throw new IOException(pathName + " not found through CommonResources");
        }
        return componentNode;
    }

    public static EffectiveNode getEffectiveNode(DescriptiveNode descriptionNode) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ComponentFactory fact = new ComponentFactory(descriptionNode);
        EffectiveNode top = fact.build();
        top.doCallsFromTop();
        return top;
    }

    public static EffectiveNode getEffectiveNodeFromFile(String descriptionName) throws Exception {
        DescriptiveNode descriptiveNode = BootUtils.getDescriptiveNode(descriptionName);
        return BootUtils.getEffectiveNode(descriptiveNode);
    }

    public static Subsystem getSubsystemFromFile(String descriptionName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, null);
    }

    public static Subsystem getSubsystemFromFile(String descriptionName, String configName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, configName, null);
    }

    public static Subsystem getSubsystemFromFile(String pathName, String propertiesFileName, String subsystemAlias) throws Exception {
        return new LocalBootObject(pathName, propertiesFileName, subsystemAlias).getSubsystem();
    }

    public static void saveInCache(DescriptiveNode node, String subsystemName, String configName, String tag) {
    }

    public static DescriptiveNode getLatestInCache() {
        return null;
    }

    public static void bootFromCache() {
        throw new UnsupportedOperationException("bootFromCache");
    }

    public static void checkStaticCompatibleConfiguration(ConfigProfile profile) throws Exception {
        LocalConfigurationProxy configurationProxy = new LocalConfigurationProxy(profile);
        DescriptiveNode node = configurationProxy.getModifiedConfigurationData();
        BootUtils.getEffectiveNode(node);
    }

    static {
        boolean bl = $assertionsDisabled = !BootUtils.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev$", BootUtils.class, (String)"org-lsst-ccs-startup")) {
            throw new AssertionError();
        }
        userName = "";
        version = "1.0";
    }

    public static class LocalBootObject {
        DescriptiveNode descriptiveNode;
        DescriptiveNode modifiedDescriptiveNode;
        EffectiveNode effectiveNode;
        ConfigurableSubsystem subsystem;
        private final String subsystemName;
        private final String[] taggedCategories;
        private final String tagName;

        public LocalBootObject(String pathName) throws Exception {
            this(pathName, "");
        }

        public LocalBootObject(String pathName, String config) throws Exception {
            this(pathName, config, null);
        }

        public LocalBootObject(String pathName, String config, String subsystemAlias) throws Exception {
            if (config == null) {
                config = "";
            }
            if (config.contains("/")) {
                throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
            }
            if (config.contains(".")) {
                throw new IllegalArgumentException("configuration input must be the name of the configuration only");
            }
            if (pathName.contains("/")) {
                throw new IllegalArgumentException("description files must be located at the root of a resource directory");
            }
            if (pathName.endsWith(".groovy")) {
                CCSCst.LOG_INIT.warn((Object)"Description file extension has to be skipped in the --description argument");
            }
            this.descriptiveNode = BootUtils.getDescriptiveNode(pathName);
            if (!(this.descriptiveNode instanceof MainDescriptiveNode)) {
                throw new RuntimeException("decriptive node is not an instance of MainDescriptiveNode");
            }
            this.subsystemName = subsystemAlias == null ? ((MainDescriptiveNode)this.descriptiveNode).getSubsystemName() : subsystemAlias;
            this.taggedCategories = config.split(",");
            this.tagName = pathName;
            CCSCst.LOG_TODO.fine((Object)"TODO: Configuration proxy should also be able to interact with remote database (switch between local and remote?)");
            SubsystemDescription subsystemDescription = Factories.createSubsystemDescription((String)this.subsystemName, (String)this.tagName, (String)userName, (String)version, (Serializable)this.descriptiveNode, (DataFlavour)DataFlavour.PURE_OBJECT_TREE, (ParameterFilter)SubsystemDescription.DEFAULT_TREE_PARAMETER_FILTER);
            LocalConfigurationProxy proxy = new LocalConfigurationProxy(subsystemDescription);
            this.subsystem = new NodeModularSubsystem(this.subsystemName, this.tagName, (ConfigurationProxy)proxy, this.taggedCategories);
        }

        public DescriptiveNode getDescriptiveNode() {
            return this.descriptiveNode;
        }

        public DescriptiveNode getModifiedDescriptiveNode() {
            return this.modifiedDescriptiveNode;
        }

        public Subsystem getSubsystem() {
            return this.subsystem;
        }

        public String getSubsystemName() {
            return this.subsystemName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public Object getRunningObject(String key) {
            return ((NodeModularSubsystem)this.subsystem).getLookup().getComponentByName(key);
        }
    }
}

