/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Resource;
import org.lsst.ccs.CCSProxy;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.ConfigurableSubsystem;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.framework.PackCst;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.utilities.structs.ViewValue;

public interface Configurable {
    public void setEnvironment(Environment var1);

    public Environment getEnvironment();

    default public Subsystem getSubsystem() {
        Optional<ConfigurableSubsystem> opt = this.getEnvironment().getSubsystem();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    default public void init() {
        this.injectResources();
    }

    default public void start() {
    }

    default public void postStart() throws HardwareException {
    }

    default public void shutdownNow() {
    }

    default public String getName() {
        Environment env = this.getEnvironment();
        if (env != null) {
            return this.getEnvironment().getNameOfComponent();
        }
        return null;
    }

    default public void alias(String alias) {
        this.getEnvironment().alias(alias);
    }

    default public Object getComponentByName(String name) {
        return this.getEnvironment().getComponentByName(name);
    }

    default public <T> LinkedHashMap<String, T> getChildren(Class<T> clazz) {
        return this.getEnvironment().getChildren(clazz);
    }

    default public List<Configurable> listChildren() {
        return this.getEnvironment().listChildren();
    }

    default public Object getParentObject() {
        return this.getEnvironment().getParent().getValue();
    }

    default public Map.Entry<String, Object> getParent() {
        return this.getEnvironment().getParent();
    }

    default public String getFullPath() {
        Configurable parent = (Configurable)this.getParentObject();
        if (parent == null) {
            return this.getName();
        }
        return parent.getFullPath() + "/" + this.getName();
    }

    default public void injectResources() {
        Class<?> clazz = this.getClass();
        while (clazz.getCanonicalName().startsWith("org.lsst")) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Resource resource = field.getAnnotation(Resource.class);
                if (resource == null) continue;
                String name = resource.name();
                if (name == null || "".equals(name)) {
                    name = field.getName();
                }
                Object toInject = this.getEnvironment().getComponentByName(name);
                if (name == null) {
                    PackCst.CURLOG.warn((Object)(this.getName() + " No possible injection for " + name));
                    continue;
                }
                try {
                    field.setAccessible(true);
                    field.set(this, toInject);
                    PackCst.CURLOG.info((Object)(toInject + " object injected in " + name + "field  "));
                }
                catch (IllegalAccessException e) {
                    PackCst.CURLOG.warn((Object)(this.getName() + " No possible injection for " + name), (Throwable)e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    @Command(description="engineering mode change of parameter value", type=Command.CommandType.CONFIGURATION)
    default public void change(@Argument(name="parameterName", description="Configuration parameter name") String parameterName, @Argument(name="value", description="Configuration parameter value") Object value) throws Exception {
        this.getEnvironment().change(parameterName, value);
    }

    default public ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
        ViewValue data = this.getEnvironment().getCheckedValueFromConfiguration(parameterName, value);
        return data;
    }

    default public void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
        this.getEnvironment().notifyChangeWithoutPreliminaryChecks(parameterName, value);
    }

    default public void notifyChange(String parameterName, String value) throws Exception {
        this.getEnvironment().notifyChange(parameterName, value);
    }

    default public void proceduralWalk(Consumer<Configurable> pre, Consumer<Configurable> post) {
        if (pre != null) {
            pre.accept(this);
        }
        for (Configurable child : this.listChildren()) {
            child.proceduralWalk(pre, post);
        }
        if (post != null) {
            post.accept(this);
        }
    }

    default public TreeWalkerDiag treeWalk(Function<Configurable, TreeWalkerDiag> func, Consumer<Configurable> post) {
        TreeWalkerDiag diag = TreeWalkerDiag.GO;
        if (func != null) {
            diag = func.apply(this);
        }
        switch (diag) {
            case STOP: {
                return diag;
            }
            case HANDLING_CHILDREN: {
                return diag;
            }
        }
        for (Configurable child : this.listChildren()) {
            TreeWalkerDiag childRes = child.treeWalk(func, post);
            if (!childRes.equals((Object)TreeWalkerDiag.STOP)) continue;
            return childRes;
        }
        if (post != null) {
            post.accept(this);
        }
        return diag;
    }

    public static class Environment {
        private static final HashMap<String, Map<String, Method>> METHOD_MAP = new HashMap();
        private final String name;
        private final Object relevantObject;
        private final Map<String, Method> configMethods;
        private final ConfigurationProxy configurationProxy;
        private final ComponentLookupService lookupService;

        public Environment(String name, Configurable currentObject, ConfigurationProxy configurationProxy, ComponentLookupService lookupService) {
            this.name = name;
            this.relevantObject = currentObject instanceof CCSProxy ? ((CCSProxy)((Object)currentObject)).getDelegate() : Objects.requireNonNull(currentObject);
            this.configurationProxy = Objects.requireNonNull(configurationProxy);
            this.lookupService = Objects.requireNonNull(lookupService);
            Class<?> clazz = this.relevantObject.getClass();
            String clazzName = clazz.getName();
            Map<String, Method> confMethods = METHOD_MAP.get(clazzName);
            if (confMethods == null) {
                this.configMethods = new HashMap<String, Method>();
                METHOD_MAP.put(clazzName, this.configMethods);
                for (Method method : clazz.getMethods()) {
                    String propertyName;
                    String methodName = method.getName();
                    ConfigChanger configChanger = method.getAnnotation(ConfigChanger.class);
                    if (configChanger == null) continue;
                    if (methodName.startsWith("set")) {
                        char firstLetter = methodName.charAt(3);
                        String propertyName2 = Character.toLowerCase(firstLetter) + methodName.substring(4);
                        this.configMethods.put(propertyName2, method);
                    }
                    if ("".equals(propertyName = configChanger.propertyName())) continue;
                    this.configMethods.put(propertyName, method);
                }
            } else {
                this.configMethods = confMethods;
            }
        }

        public void change(String parameterName, Object value) throws Exception {
            if (!this.isInEngineeringMode()) {
                throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
            }
            this.getSubsystem().get().change(this.name, parameterName, value);
        }

        @Deprecated
        public void register(String configurationName) throws ConfigurationServiceException {
            this.saveChangesForCategoriesAs(configurationName);
        }

        @Deprecated
        public void saveConfiguration() throws ConfigurationServiceException {
            this.saveAllChanges();
        }

        @Deprecated
        public void saveConfiguration(String configName) throws ConfigurationServiceException {
            this.saveChangesForCategoriesAs(configName);
        }

        public void saveAllChanges() throws ConfigurationServiceException {
            if (!this.isInEngineeringMode()) {
                throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
            }
            this.getSubsystem().get().saveAllChanges();
        }

        public void saveChangesForCategories(String ... categories) throws ConfigurationServiceException {
            if (!this.isInEngineeringMode()) {
                throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
            }
            this.getSubsystem().get().saveChangesForCategories(categories);
        }

        public void saveChangesForCategoriesAs(String ... taggedCategories) throws ConfigurationServiceException {
            if (!this.isInEngineeringMode()) {
                throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
            }
            this.getSubsystem().get().saveChangesForCategoriesAs(taggedCategories);
        }

        public void dropAllChanges() throws Exception {
            if (!this.isInEngineeringMode()) {
                throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
            }
            this.getSubsystem().get().dropAllChanges();
        }

        public void dropChangesForCategories(String ... categories) throws Exception {
            if (!this.isInEngineeringMode()) {
                throw new IllegalStateException("Configuration actions are accepted only in engineering mode");
            }
            this.getSubsystem().get().dropChangesForCategories(categories);
        }

        private boolean isInEngineeringMode() {
            return this.getSubsystem().get().isInEngineeringMode();
        }

        public ViewValue getCheckedValueFromConfiguration(String parameterName, Object value) throws Exception {
            ViewValue data = this.configurationProxy.checkForParameterChange(this.name, parameterName, value);
            return data;
        }

        public void notifyChangeWithoutPreliminaryChecks(String parameterName, Object value) throws Exception {
            this.configurationProxy.notifyUncheckedParameterChange(this.name, parameterName, value);
        }

        protected void notifyChange(String parameterName, String value) throws Exception {
            this.configurationProxy.notifyParameterChange(this.name, parameterName, value);
        }

        public Object getComponentByName(String name) {
            return this.lookupService.getComponentByName(name);
        }

        public void alias(String name) {
            this.lookupService.aliasObject(name, this.relevantObject);
        }

        public <T> LinkedHashMap<String, T> getChildren(Class<T> classFilter) {
            Objects.requireNonNull(classFilter);
            return this.lookupService.getChildren(this.name, classFilter);
        }

        public List<Configurable> listChildren() {
            return this.lookupService.listChildren(this.name);
        }

        public Map.Entry<String, Object> getParent() {
            return this.lookupService.getParent(this.name);
        }

        public String getNameOfComponent() {
            return this.name;
        }

        public Object getRelevantObject() {
            return this.relevantObject;
        }

        @Deprecated
        public Map<String, Method> getConfigMethodsOfComponent() {
            return this.configMethods;
        }

        public Method getConfigMethodOfComponent(String parameterName) {
            Method res = this.configMethods.get(parameterName);
            if (res == null) {
                throw new IllegalArgumentException(" no such config property :" + parameterName);
            }
            return res;
        }

        public Optional<ConfigurableSubsystem> getSubsystem() {
            return this.lookupService.getSubsystem();
        }
    }
}

