/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.AConfigProfile;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.MemoryDAO;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.RollBackException;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.ConfigurationServiceException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.functions.Cocoon;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ViewValue;
import org.lsst.gruth.jutils.Constraints;
import org.lsst.gruth.jutils.DescriptiveNode;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.types.TypeUtils;

public class LocalConfigurationProxy
implements ConfigurationProxy {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_CAT = "";
    private final ASubsystemDescription subsystemDescription;
    private final String subsystemName;
    private final String tagName;
    private final Map<String, AConfigProfile> configProfileMap = new HashMap<String, AConfigProfile>();
    Logger logger = Logger.getLogger((String)"org.lsst.ccs.config");
    private ComponentLookupService lookup;
    private ConfigurationState configState = ConfigurationState.UNCONFIGURED;
    private WriterProvider writerProvider = new WriterProvider(){

        @Override
        public PrintWriter getPrintWriter(String baseName) throws IOException {
            String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)baseName);
            if (pathInBootstrap == null) {
                String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
                if (topMostUserDirectory == null) {
                    String workdir = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.workdir", "");
                    if (!workdir.isEmpty() && !workdir.endsWith(FILE_SEPARATOR)) {
                        workdir = workdir + FILE_SEPARATOR;
                    }
                    baseName = workdir + baseName;
                } else {
                    baseName = topMostUserDirectory + baseName;
                }
            } else {
                baseName = pathInBootstrap;
            }
            if (!baseName.endsWith(".properties")) {
                baseName = baseName + ".properties";
            }
            LocalConfigurationProxy.this.logger.info((Object)("Saving configuration  to " + baseName));
            return new PrintWriter(baseName, "ISO-8859-1");
        }

        @Override
        public Properties getConfigurationProperties(String configFileName) throws IOException {
            if (!configFileName.endsWith(".properties")) {
                configFileName = configFileName + ".properties";
            }
            Properties configProps = new Properties();
            InputStream propsIs = null;
            propsIs = BootstrapResourceUtils.getBootstrapResource((String)configFileName);
            if (propsIs == null) {
                throw new IllegalArgumentException("Could not find configuration file : " + configFileName);
            }
            configProps.load(propsIs);
            return configProps;
        }
    };

    public LocalConfigurationProxy(SubsystemDescription subsystemDesc) {
        this.subsystemDescription = (ASubsystemDescription)subsystemDesc;
        this.subsystemName = this.subsystemDescription.getSubsystemName();
        this.tagName = this.subsystemDescription.getTag();
        if (System.getProperty("org.lsst.ccs.testcontext", "false").equals("true")) {
            this.writerProvider = InMemoryWriterProvider.getInstance();
        }
    }

    public LocalConfigurationProxy(ConfigProfile configProfile) {
        this(configProfile.getSubsystemDescription());
        this.configProfileMap.put(configProfile.getCategoryName(), (AConfigProfile)configProfile);
    }

    public Set<String> getCategorySet() {
        return this.subsystemDescription.getCategorySet();
    }

    public TreeNode getInitialDescriptiveNode(Map<String, String> taggedCategories) {
        DescriptiveNode modifiedDescriptiveNode = this.subsystemDescription.getTopComponentNode();
        CCSCst.LOG_TODO.fine((Object)"TODO: DAO at creation of SubsystemDescription should also be able to interact with remote database (switch between local and remote?)");
        MemoryDAO dao = new MemoryDAO();
        dao.saveAbstractDescription(this.subsystemDescription);
        boolean exceptionThrown = false;
        for (Map.Entry<String, String> entry : taggedCategories.entrySet()) {
            AConfigProfile profileForCat;
            Properties configProps = null;
            try {
                configProps = this.loadPropertiesForCat(entry.getKey(), entry.getValue());
                profileForCat = this.createConfigProfileOutOfProperties(configProps, entry.getKey(), entry.getValue());
            }
            catch (IOException ex) {
                exceptionThrown = true;
                profileForCat = this.createConfigProfileOutOfProperties(configProps, entry.getKey(), "");
            }
            this.configProfileMap.put(profileForCat.getCategoryName(), profileForCat);
            this.configState = exceptionThrown ? ConfigurationState.UNCONFIGURED : ConfigurationState.CONFIGURED;
        }
        modifiedDescriptiveNode = this.getModifiedConfigurationData();
        return modifiedDescriptiveNode;
    }

    public void setLookup(ComponentLookupService lookup) {
        this.lookup = lookup;
    }

    public String getTagName() {
        return this.tagName;
    }

    public synchronized ConfigurationInfo buildConfigurationInfo() {
        HashMap<String, String> tags = new HashMap<String, String>();
        HashMap<String, Boolean> hasCatChanges = new HashMap<String, Boolean>();
        ArrayList<ConfigurationParameterInfo> parametersView = new ArrayList<ConfigurationParameterInfo>();
        for (ConfigProfile configProfile : this.configProfileMap.values()) {
            String category = configProfile.getCategoryName();
            tags.put(category, configProfile.getConfigName());
            hasCatChanges.put(configProfile.getCategoryName(), configProfile.isDirty());
            for (ParameterDescription parmDesc : this.subsystemDescription.getParamDescriptions().stream().filter(desc -> desc.getCategory().equals(category)).collect(Collectors.toSet())) {
                ParameterConfiguration parmConfig = configProfile.fetch(parmDesc);
                ConfigurationParameterInfo configParameterInfo = parmConfig != null ? new ConfigurationParameterInfo(parmDesc.getPath().toString(), parmDesc.getCategory(), parmDesc.getDefaultValue(), parmConfig.getConfiguredValue(), parmConfig.getValueAt(PackCst.STILL_VALID), parmConfig.hasChanged()) : new ConfigurationParameterInfo(parmDesc.getPath().toString(), parmDesc.getCategory(), parmDesc.getDefaultValue(), parmDesc.getDefaultValue(), parmDesc.getDefaultValue(), false);
                parametersView.add(configParameterInfo);
            }
        }
        return new ConfigurationInfo(this.configState, this.tagName, tags, hasCatChanges, parametersView);
    }

    public ViewValue checkForParameterChange(String componentName, String parameterName, Object value) {
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        ParameterDescription parameterDescription = this.subsystemDescription.fetch(path);
        if (null == parameterDescription) {
            throw new IllegalArgumentException("incoherent parameter name for " + parameterName + "-> " + this.subsystemName);
        }
        if (parameterDescription.isNotModifiableAtRuntime()) {
            throw new IllegalStateException(" parameter " + parameterName + " not modifiable at runtime");
        }
        Object res = parameterDescription.checkValue(strValue);
        return new ViewValue(strValue, res);
    }

    public synchronized void notifyParameterChange(String componentName, String parameterName, String value) {
        ParameterPath parameterPath = new ParameterPath(componentName, "", parameterName);
        String category = this.subsystemDescription.fetch(parameterPath).getCategory();
        this.configProfileMap.get(category).temporaryChangeConfigurationValue(parameterPath.toString(), System.currentTimeMillis(), value, true);
    }

    public synchronized void notifyUncheckedParameterChange(String componentName, String parameterName, Object value) {
        ParameterPath parameterPath = new ParameterPath(componentName, "", parameterName);
        String strValue = value instanceof String ? (String)value : TypeUtils.stringify((Object)value);
        String category = this.subsystemDescription.fetch(parameterPath).getCategory();
        this.configProfileMap.get(category).temporaryChangeConfigurationValue(parameterPath.toString(), System.currentTimeMillis(), strValue, false);
    }

    public synchronized void saveChangesForCategoriesAs(Map<String, String> taggedCategories) throws ConfigurationServiceException {
        for (Map.Entry<String, String> taggedCategory : taggedCategories.entrySet()) {
            try {
                PrintWriter printWriter = this.writerProvider.getPrintWriter(ConfigUtils.baseNameFromNames(taggedCategory.getValue(), this.tagName, taggedCategory.getKey()));
                for (ParameterConfiguration parameterConfiguration : this.configProfileMap.get(taggedCategory.getKey()).getModifiedParameters()) {
                    String currentValue = parameterConfiguration.getValueAt(PackCst.STILL_VALID);
                    boolean commentOut = currentValue.equals(parameterConfiguration.getDescription().getDefaultValue());
                    printWriter.println(parameterConfiguration.getDescription().toPropertyString(currentValue, commentOut));
                }
                printWriter.flush();
                printWriter.close();
                this.saveModifications(taggedCategory.getKey(), taggedCategory.getValue());
            }
            catch (IOException ex) {
                this.configState = ConfigurationState.UNCONFIGURED;
                throw new ConfigurationServiceException("configuration service unavailable", (Throwable)ex);
            }
        }
        this.configState = this.isDirty() ? ConfigurationState.DIRTY : ConfigurationState.CONFIGURED;
    }

    public synchronized void saveChangesForCategories(Set<String> categories) throws ConfigurationServiceException {
        this.saveChangesForCategoriesAs(this.getTaggedCategoriesForCats(categories));
    }

    private Map<String, String> getTaggedCategoriesForCats(Set<String> categories) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String category : categories) {
            res.put(category, this.configProfileMap.get(category).getConfigName());
        }
        return res;
    }

    private synchronized void saveModifications(String category, String configName) {
        AConfigProfile oldProfile = this.configProfileMap.get(category);
        AConfigProfile newProfile = new AConfigProfile(oldProfile, "", 10, false, configName);
        this.configProfileMap.put(category, newProfile);
    }

    public Object getDefaultParameterValue(String componentName, String parameterName) {
        ParameterPath path = new ParameterPath(componentName, "", parameterName);
        ParameterDescription parameterDescription = this.subsystemDescription.fetch(path);
        String strValue = parameterDescription.getDefaultValue();
        String type = parameterDescription.getTypeName();
        Object res = Constraints.check((String)type, (String)strValue, null);
        return res;
    }

    private synchronized Properties loadPropertiesForCat(String categoryName, String configName) throws IOException {
        Properties props;
        block2: {
            props = new Properties();
            try {
                props.putAll((Map<?, ?>)this.writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames(configName, this.tagName, categoryName)));
            }
            catch (IllegalArgumentException ex) {
                if (configName.equals("")) break block2;
                throw ex;
            }
        }
        return props;
    }

    public void setWriterProvider(WriterProvider writerProvider) {
        this.writerProvider = writerProvider;
    }

    public WriterProvider getWriterProvider() {
        return this.writerProvider;
    }

    private boolean isDirty() {
        return this.configProfileMap.values().stream().map(ConfigProfile::isDirty).reduce(false, (a, b) -> a != false || b != false);
    }

    public void loadCategories(Map<String, String> taggedCategories) throws ConfigurationServiceException, Exception {
        if (taggedCategories.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : taggedCategories.entrySet()) {
            try {
                Properties configProps = this.loadPropertiesForCat(entry.getKey(), entry.getValue());
                AConfigProfile newConfigProfile = this.createConfigProfileOutOfProperties(configProps, entry.getKey(), entry.getValue());
                this.switchConfiguration(this.configProfileMap.get(entry.getKey()), newConfigProfile);
                this.configProfileMap.put(newConfigProfile.getCategoryName(), newConfigProfile);
                this.saveModifications(entry.getKey(), entry.getValue());
            }
            catch (IOException ex) {
                this.configState = ConfigurationState.UNCONFIGURED;
                throw new ConfigurationServiceException("configuration service problem", (Throwable)ex);
            }
            catch (Exception ex) {
                this.configState = ConfigurationState.DIRTY;
                throw ex;
            }
        }
        this.configState = this.isDirty() ? ConfigurationState.DIRTY : ConfigurationState.CONFIGURED;
    }

    public void dropUnsavedChangesForCategories(Collection<String> categories) throws Exception {
        if (categories.isEmpty()) {
            return;
        }
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        Map<String, List<ParameterConfiguration>> oldMap = this.getConfigurationMapForCat(categories);
        mainModule.proceduralWalk(null, Cocoon.consumer(configurable -> {
            String name = configurable.getName();
            List<ParameterConfiguration> oldList = (List<ParameterConfiguration>)oldMap.get(name);
            if (oldList == null) {
                oldList = Collections.emptyList();
            }
            try {
                for (ParameterConfiguration parmConfig : oldList) {
                    if (!categories.contains(parmConfig.getDescription().getCategory())) continue;
                    ParameterPath path = parmConfig.getPath();
                    String parameterName = path.getParameterName();
                    String value = parmConfig.getConfiguredValue();
                    if (parmConfig.getDescription().isNotModifiableAtRuntime()) {
                        throw new IllegalArgumentException(path + "not modifiable at runtime");
                    }
                    this.change((Configurable)configurable, parameterName, value);
                }
            }
            catch (Exception exc) {
                this.configState = ConfigurationState.DIRTY;
                throw exc;
            }
        }));
        for (String cat : categories) {
            this.saveModifications(cat, this.configProfileMap.get(cat).getConfigName());
        }
        this.configState = this.isDirty() ? ConfigurationState.DIRTY : ConfigurationState.CONFIGURED;
    }

    public void switchConfiguration(ConfigProfile oldProfile, ConfigProfile newProfile) throws Exception {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        Map<String, List<ParameterConfiguration>> newChanges = newProfile.getConfigurationMap();
        Map<String, List<ParameterConfiguration>> oldMap = oldProfile.getConfigurationMap();
        ArrayList changedValues = new ArrayList();
        mainModule.proceduralWalk(null, Cocoon.consumer(configurable -> {
            String name = configurable.getName();
            List newList = (List)newChanges.get(name);
            List<ParameterConfiguration> oldList = (List<ParameterConfiguration>)oldMap.get(name);
            if (oldList == null) {
                oldList = Collections.emptyList();
            }
            try {
                String[] histElement;
                String oldValue;
                String parameterName;
                ParameterPath path;
                if (newList != null) {
                    for (ParameterConfiguration parmConfig : newList) {
                        oldList.remove(parmConfig);
                        path = parmConfig.getPath();
                        parameterName = path.getParameterName();
                        String value = parmConfig.getConfiguredValue();
                        oldValue = oldProfile.getValueAt(path, PackCst.STILL_VALID);
                        if (oldValue.equals(value)) continue;
                        if (parmConfig.getDescription().isNotModifiableAtRuntime()) {
                            throw new IllegalArgumentException(path + "not modifiable at runtime");
                        }
                        histElement = new String[]{name, parameterName, oldValue};
                        this.change((Configurable)configurable, parameterName, value);
                        changedValues.add(0, histElement);
                    }
                }
                for (ParameterConfiguration parmConfig : oldList) {
                    path = parmConfig.getPath();
                    parameterName = path.getParameterName();
                    String defaultValue = parmConfig.getDescription().getDefaultValue();
                    oldValue = oldProfile.getValueAt(path, PackCst.STILL_VALID);
                    if (parmConfig.getDescription().isNotModifiableAtRuntime()) {
                        throw new IllegalArgumentException(path + "not modifiable at runtime");
                    }
                    histElement = new String[]{name, parameterName, oldValue};
                    configurable.change(parameterName, (Object)defaultValue);
                    changedValues.add(0, histElement);
                }
            }
            catch (Exception exc) {
                for (String[] historyElement : changedValues) {
                    String cpName = historyElement[0];
                    String parmName = historyElement[1];
                    String histValue = historyElement[2];
                    try {
                        Configurable cp = (Configurable)this.lookup.getComponentByName(cpName);
                        cp.change(parmName, (Object)histValue);
                    }
                    catch (Exception rollbackExc) {
                        throw new RollBackException(rollbackExc, cpName, parmName, histValue);
                    }
                }
                throw exc;
            }
        }));
    }

    private AConfigProfile createConfigProfileOutOfProperties(Properties configProps, String categoryName, String configName) {
        AConfigProfile res = new AConfigProfile(this.subsystemDescription, this.subsystemDescription.getUser(), 10, categoryName, configName);
        if (configProps != null) {
            try {
                boolean exceptionThrown = false;
                for (String name : configProps.stringPropertyNames()) {
                    try {
                        res.addParameterConfiguration(name, configProps.getProperty(name));
                    }
                    catch (Exception ex) {
                        exceptionThrown = true;
                    }
                }
                if (exceptionThrown) {
                    throw new IllegalArgumentException("Some parameters were not modifiable, invoke getReConfigurationFailures");
                }
            }
            catch (IllegalArgumentException exc) {
                List<String> messages = res.reportFailures();
                throw new IllegalArgumentException(" configuration errors :" + messages);
            }
        }
        return res;
    }

    public ConfigProfile getProfileForCat(String categoryName) {
        return this.configProfileMap.get(categoryName);
    }

    private Map<String, List<ParameterConfiguration>> getConfigurationMapForCat(Collection<String> categories) {
        return this.getParameterConfigurationsForCat(categories).stream().collect(Collectors.groupingBy(c -> c.getPath().getComponentName()));
    }

    private Set<AParameterConfiguration> getParameterConfigurationsForCat(Collection<String> categories) {
        HashSet<AParameterConfiguration> res = new HashSet<AParameterConfiguration>();
        for (String category : categories) {
            res.addAll(this.configProfileMap.get(category).getParameterConfigurations());
        }
        return res;
    }

    public DescriptiveNode getModifiedConfigurationData() {
        DescriptiveNode res = null;
        DescriptiveNode componentNode = this.subsystemDescription.getTopComponentNode().clone();
        for (AParameterConfiguration parameterConfiguration : this.getParameterConfigurationsForCat(this.subsystemDescription.getCategorySet())) {
            ParameterPath path = parameterConfiguration.getPath();
            String componentName = path.getComponentName();
            String codeName = path.getCodeName();
            if (codeName != null && !"".equals(codeName)) {
                throw new UnsupportedOperationException(" no change on methods yet --> " + codeName);
            }
            String parameterName = path.getParameterName();
            DescriptiveNode goalComponent = (DescriptiveNode)componentNode.getNodeByName(componentName);
            if (goalComponent == null) {
                throw new IllegalArgumentException("no component for name :" + componentName);
            }
            Map mapAttributes = goalComponent.getAttributes();
            if (mapAttributes == null) {
                throw new IllegalArgumentException("incompatible attribute list for component/parameter " + componentName + "/" + parameterName);
            }
            Object rawParm = mapAttributes.get(parameterName);
            if (rawParm instanceof HollowParm) {
                HollowParm hollow = (HollowParm)rawParm;
                hollow.modifyChecked((Object)parameterConfiguration.getConfiguredValue());
                continue;
            }
            throw new IllegalArgumentException("parameter not modifiable" + rawParm);
        }
        res = componentNode;
        return res;
    }

    public void change(Configurable configurable, String parameterName, Object value) throws Exception {
        Method method = configurable.getEnvironment().getConfigMethodOfComponent(parameterName);
        ViewValue data = this.checkForParameterChange(configurable.getName(), parameterName, value);
        method.invoke(configurable.getEnvironment().getRelevantObject(), data.getValue());
        this.notifyParameterChange(configurable.getName(), parameterName, data.getView());
    }

    public static interface WriterProvider {
        public PrintWriter getPrintWriter(String var1) throws IOException;

        public Properties getConfigurationProperties(String var1) throws IOException;
    }
}

