/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console;

import java.util.ArrayList;
import java.util.List;
import jline.console.completer.Completer;

public class TargetArgumentCompleter
implements Completer {
    private ArrayList<String> targets = new ArrayList();
    private String[] specialCmds;

    TargetArgumentCompleter(String[] specialCmds) {
        this.specialCmds = specialCmds;
    }

    public void addTarget(String target) {
        this.targets.add(target);
    }

    public void removeTarget(String target) {
        this.targets.remove(target);
    }

    public int complete(String buffer, int i, List<CharSequence> list) {
        String targetStr = null;
        String internalBuffer = buffer.trim();
        String cmd = null;
        for (String specialCmd : this.specialCmds) {
            if (!internalBuffer.startsWith(specialCmd)) continue;
            targetStr = internalBuffer.replace(specialCmd, "").trim();
            cmd = specialCmd;
            break;
        }
        if (targetStr != null) {
            for (String target : this.targets) {
                if (!target.startsWith(targetStr) || target.equals(targetStr)) continue;
                list.add(cmd + " " + target);
            }
        }
        return -1;
    }
}

