/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.jars;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.lsst.ccs.utilities.jars.CommonResources;

public class MavenResources {
    public static URL[] getPomURLs(String org, String project) {
        String path = "/META-INF/maven/" + org + "/" + project + "/pom.properties";
        return CommonResources.getURLsFrom(path);
    }

    public static URL[] getMavenProjectURLs(String project) {
        String path = project + ".maven.properties";
        return CommonResources.getURLsFrom(path);
    }

    public static Properties getPomProperties(String org, String project) {
        String path = "/META-INF/maven/" + org + "/" + project + "/pom.properties";
        Properties res = new Properties();
        try (InputStream is = MavenResources.class.getResourceAsStream(path);){
            if (is != null) {
                res.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public static Properties getMavenProjectProperties(String project) {
        String path = "/" + project + ".maven.properties";
        Properties res = new Properties();
        try (InputStream is = MavenResources.class.getResourceAsStream(path);){
            if (is != null) {
                res.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }
}

