/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dispatch;

import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import org.lsst.ccs.utilities.dispatch.Invoker;

public class InvocationDispenser {
    private static AtomicLong seed = new AtomicLong(System.nanoTime());
    private LinkedHashMap<String, Invoker> map = new LinkedHashMap();

    public String generateToken() {
        long longKey = seed.getAndIncrement();
        String key = Long.toString(longKey, 36);
        return key;
    }

    public synchronized String register(Invoker invoker) {
        if (invoker == null) {
            throw new IllegalArgumentException("null Invoker");
        }
        String key = this.generateToken();
        this.map.put(key, invoker);
        return key;
    }

    public synchronized String register(String token, Invoker invoker) {
        if (invoker == null) {
            throw new IllegalArgumentException("null Invoker");
        }
        this.map.put(token, invoker);
        return token;
    }

    public synchronized Future registerFuture(String token, Invoker invoker) {
        if (invoker == null) {
            throw new IllegalArgumentException("null Invoker");
        }
        DelegateInvoker delegateInvoker = new DelegateInvoker(invoker);
        this.map.put(token, delegateInvoker);
        return delegateInvoker.getTask();
    }

    public synchronized void dumpTask(String token) {
        this.map.remove(token);
    }

    public synchronized boolean isTokenUsed(String token) {
        if (token == null) {
            return false;
        }
        return this.map.containsKey(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callBack(String token, Object ... args) throws Exception {
        Invoker invoker;
        InvocationDispenser invocationDispenser = this;
        synchronized (invocationDispenser) {
            invoker = (Invoker)this.map.remove(token);
            if (invoker == null) {
                throw new TokenLostException(token);
            }
        }
        return invoker.invoke(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(String token, Object ... args) throws Exception {
        Invoker invoker;
        InvocationDispenser invocationDispenser = this;
        synchronized (invocationDispenser) {
            invoker = this.map.get(token);
            if (invoker == null) {
                throw new TokenLostException(token);
            }
        }
        return invoker.invoke(args);
    }

    class DelegateInvoker
    implements Invoker {
        Invoker delegate;
        Object res;
        FutureTask task = new FutureTask(new Callable(){

            public Object call() throws Exception {
                return DelegateInvoker.this.getRes();
            }
        });

        Object getRes() {
            return this.res;
        }

        public DelegateInvoker(Invoker delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object ... args) throws Exception {
            this.res = this.delegate.invoke(args);
            this.task.run();
            return this.res;
        }

        public FutureTask getTask() {
            return this.task;
        }
    }

    public static class TokenLostException
    extends Exception {
        public final String token;

        public TokenLostException(String token) {
            this.token = token;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.token;
        }
    }
}

