/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.ConfigurableSubsystem;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.utilities.structs.UniquePair;
import org.lsst.gruth.jutils.EffectiveNode;

public class NodeLookup
implements ComponentLookupService {
    private EffectiveNode top;
    private ConfigurableSubsystem subsystem;
    private Map<String, Object> aliases = new HashMap<String, Object>();

    public NodeLookup(NodeModularSubsystem sub, EffectiveNode top) {
        this.top = top;
        this.subsystem = sub;
    }

    public Object getComponentByName(String name) {
        Object res = this.top.getIndirect((Object)name);
        if (res == null) {
            return this.aliases.get(name);
        }
        return res;
    }

    public Optional<ConfigurableSubsystem> getSubsystem() {
        return Optional.ofNullable(this.subsystem);
    }

    public void aliasObject(String alias, Object object) {
        this.aliases.put(alias, object);
    }

    public <T> LinkedHashMap<String, T> getChildren(String parentName, Class<T> classFilter) {
        EffectiveNode current = (EffectiveNode)this.top.getNodeByName(parentName);
        ArrayList children = current.getChildren();
        if (children == null) {
            return new LinkedHashMap(0);
        }
        LinkedHashMap<String, Object> mapRes = new LinkedHashMap<String, Object>(children.size());
        for (EffectiveNode child : children) {
            Object realValue = child.getRealValue();
            if (!classFilter.isAssignableFrom(realValue.getClass())) continue;
            Object realChild = realValue;
            String key = child.getKey();
            mapRes.put(key, realChild);
        }
        return mapRes;
    }

    public <T> List<T> listChildren(String parentName) {
        EffectiveNode current = (EffectiveNode)this.top.getNodeByName(parentName);
        ArrayList children = current.getChildren();
        if (children == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>(children.size());
        for (EffectiveNode node : children) {
            result.add(node.getRealValue());
        }
        return result;
    }

    public Map.Entry<String, Object> getParent(String componentName) {
        EffectiveNode current = (EffectiveNode)this.top.getNodeByName(componentName);
        EffectiveNode parent = (EffectiveNode)current.getParent();
        if (parent == null) {
            return new UniquePair((Object)"_EDEN_", null);
        }
        String key = parent.getKey();
        Object value = parent.getRealValue();
        return new UniquePair((Object)key, value);
    }
}

