/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.ParameterFilter;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.gruth.jutils.DescriptiveNode;

public class LocalDescriptionToConfigurationText {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("usage: java org.lsst.ccs.startup.LocalDescriptionToConfigurationText pathName\n where filename is  xx.ser or xx.groovy or xx.groo\n pathName could be file (with '/' file separator) or resource path");
            System.exit(1);
        }
        String pathName = args[0];
        DescriptiveNode descriptiveNode = BootUtils.getDescriptiveNode(pathName);
        NamesAndTag namesAndTag = ConfigUtils.namesFromDescriptionPath((String)pathName);
        ASubsystemDescription subsystemDescription = (ASubsystemDescription)Factories.createSubsystemDescription((String)namesAndTag.getSubsystemName(), (String)namesAndTag.getTag(), (String)"", (String)"", (Serializable)descriptiveNode, (DataFlavour)DataFlavour.PURE_OBJECT_TREE, (ParameterFilter)SubsystemDescription.DEFAULT_TREE_PARAMETER_FILTER);
        Set categorySet = subsystemDescription.getCategorySet();
        HashMap<String, PrintWriter> printWriterMap = new HashMap<String, PrintWriter>();
        for (String cat : categorySet) {
            printWriterMap.put(cat, new PrintWriter(String.valueOf(ConfigUtils.baseNameFromNames((String)"XXXXX", (String)namesAndTag.getTag(), (String)cat)) + ".properties", "ISO-8859-1"));
        }
        subsystemDescription.generateConfigProperties(printWriterMap, 10);
        for (PrintWriter pm : printWriterMap.values()) {
            pm.flush();
            pm.close();
        }
    }
}

