/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.scripting.ScriptingStatusBusListener;
import org.lsst.ccs.scripting.ScriptingStatusBusMessage;
import org.lsst.ccs.scripting.ScriptingStatusBusMessageFilter;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class CCS {
    private static boolean throwExceptions = true;
    private static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.scripting");
    private static final HashMap<Integer, ArrayList<ScriptingSubsystemWrapper>> subsystemsForThread = new HashMap();
    private static final HashMap<Integer, ArrayList<ScriptingStatusBusListenerWrapper>> listenersForThread = new HashMap();
    private static ConcurrentMessagingUtils cmdUtils;
    private static final AtomicInteger nextId;
    private static AgentMessagingLayer environmentAgent;
    private static Agent internalAgent;
    private static final ThreadLocal<Integer> threadId;

    static {
        nextId = new AtomicInteger(0);
        environmentAgent = null;
        internalAgent = null;
        threadId = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                Integer id = nextId.getAndIncrement();
                subsystemsForThread.put(id, new ArrayList());
                listenersForThread.put(id, new ArrayList());
                return id;
            }
        };
    }

    private CCS() {
    }

    private static ConcurrentMessagingUtils getMessagingAccessHelper() {
        if (cmdUtils == null) {
            cmdUtils = new ConcurrentMessagingUtils(CCS.getMessagingAccess());
        }
        return cmdUtils;
    }

    public static AgentMessagingLayer getMessagingAccess() {
        if (environmentAgent == null) {
            if (System.getProperty("org.lsst.ccs.testcontext", "false").equals("true")) {
                environmentAgent = CCS.getInternalMessagingAccess();
            } else {
                try {
                    environmentAgent = Agent.getEnvironmentMessagingAccess();
                }
                catch (Exception exception) {
                    environmentAgent = CCS.getInternalMessagingAccess();
                }
            }
        }
        return environmentAgent;
    }

    private static AgentMessagingLayer getInternalMessagingAccess() {
        internalAgent = new Agent("CCSScriptingAgent", AgentInfo.AgentType.CONSOLE);
        internalAgent.start();
        return internalAgent.getMessagingAccess();
    }

    public static void initializeScriptingEnvironment() {
        CCS.getMessagingAccess();
    }

    public static void shutdownScriptingEnvironment() throws Exception {
        CCS.cleanUp();
        if (internalAgent != null) {
            internalAgent.shutdown();
        }
        environmentAgent = null;
    }

    public static void setThrowExceptions(boolean throwExceptions) {
        CCS.throwExceptions = throwExceptions;
    }

    public static boolean getThrowExceptions() {
        return throwExceptions;
    }

    public static ScriptingSubsystemWrapper attachSubsystem(String subsystemName) throws RuntimeException {
        ScriptingSubsystemWrapper wrapper = new ScriptingSubsystemWrapper(subsystemName, CCS.getMessagingAccess());
        subsystemsForThread.get(threadId.get()).add(wrapper);
        logger.finest((Object)("Adding subsystem " + subsystemName + " to Thread " + threadId.get() + " for a total of " + subsystemsForThread.get(threadId.get()).size()));
        return wrapper;
    }

    public static void cleanUp() {
        ArrayList<ScriptingSubsystemWrapper> subsystems;
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(threadId.get());
        if (listeners != null) {
            for (ScriptingStatusBusListenerWrapper l : listeners) {
                CCS.cleanupListener(l);
            }
            listeners.clear();
        }
        if ((subsystems = subsystemsForThread.get(threadId.get())) != null) {
            subsystems.clear();
        }
        logger.finest((Object)("**** Cleaned up on ThreadLocal " + threadId.get()));
    }

    public static void addStatusBusListener(ScriptingStatusBusListener listener) {
        CCS.addStatusBusListener(listener, null);
    }

    public static void addStatusBusListener(ScriptingStatusBusListener listener, ScriptingStatusBusMessageFilter filter) {
        ScriptingStatusBusListenerWrapper busListener = new ScriptingStatusBusListenerWrapper(listener);
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(threadId.get());
        listeners.add(busListener);
        logger.finest((Object)("Adding listener to Thread " + threadId.get() + " for a total of " + listeners.size()));
        if (filter != null) {
            CCS.getMessagingAccess().addStatusMessageListener((StatusMessageListener)busListener, (BusMessageFilter)new ScriptingStatusBusMessageFilterWrapper(filter));
        } else {
            CCS.getMessagingAccess().addStatusMessageListener((StatusMessageListener)busListener);
        }
    }

    public static void removeStatusBusListener(ScriptingStatusBusListener listener) {
        CCS.removeStatusBusListener(listener, threadId.get());
    }

    private static void removeStatusBusListener(ScriptingStatusBusListener listener, Integer id) {
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(id);
        ScriptingStatusBusListenerWrapper toDelete = null;
        for (ScriptingStatusBusListenerWrapper l : listeners) {
            if (l.getScriptingStatusBusListener() != listener) continue;
            CCS.cleanupListener(l);
            toDelete = l;
            logger.finest((Object)("Removed listener on thread " + id + " for a total of " + listeners.size()));
            break;
        }
        if (toDelete != null) {
            listeners.remove(toDelete);
        } else {
            logger.warning((Object)("Could not remove listener " + listener + " on thread " + id));
        }
    }

    private static void cleanupListener(ScriptingStatusBusListenerWrapper listener) {
        CCS.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
    }

    public static Future<ScriptingStatusBusMessage> startListeningForStatusBusMessage(ScriptingStatusBusMessageFilter filter, int timeout) {
        Future future = CCS.getMessagingAccessHelper().startListeningForStatusBusMessage((BusMessageFilter)new ScriptingStatusBusMessageFilterWrapper(filter), (long)timeout * 1000L);
        return new FutureWrapper(future);
    }

    static class FutureWrapper
    implements Future<ScriptingStatusBusMessage> {
        private final Future<StatusMessage> future;

        public FutureWrapper(Future<StatusMessage> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public ScriptingStatusBusMessage get() throws InterruptedException, ExecutionException {
            StatusMessage msg = this.future.get();
            return new ScriptingStatusBusMessage(msg);
        }

        @Override
        public ScriptingStatusBusMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            StatusMessage msg = this.future.get(timeout, unit);
            return new ScriptingStatusBusMessage(msg);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }
    }

    static class ScriptingStatusBusListenerWrapper
    implements StatusMessageListener {
        private final ScriptingStatusBusListener scriptingListener;

        ScriptingStatusBusListenerWrapper(ScriptingStatusBusListener scriptingListener) {
            this.scriptingListener = scriptingListener;
        }

        public void onStatusMessage(StatusMessage s) {
            this.scriptingListener.onStatusBusMessage(new ScriptingStatusBusMessage(s));
        }

        protected ScriptingStatusBusListener getScriptingStatusBusListener() {
            return this.scriptingListener;
        }
    }

    static class ScriptingStatusBusMessageFilterWrapper
    extends BusMessageFilter {
        private final ScriptingStatusBusMessageFilter filter;

        ScriptingStatusBusMessageFilterWrapper(ScriptingStatusBusMessageFilter filter) {
            this.filter = filter;
        }

        protected boolean internalAccept(BusMessage busMessage) {
            if (busMessage instanceof StatusMessage) {
                return this.filter.accept(new ScriptingStatusBusMessage((StatusMessage)busMessage));
            }
            return false;
        }

        protected String internalToString() {
            return "Scripting Status Bus Message Filter " + this.filter;
        }
    }
}

