/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework.test;

import org.lsst.ccs.framework.Guarded;
import org.lsst.ccs.framework.Module;

public class GuardedActuatorForT
extends Module {
    private static final long serialVersionUID = -3038008065010618058L;
    volatile State state = State.CLOSE;
    int motionTimeMillis = 1000;

    @Override
    public void initModule() {
        log.fine((Object)("init guarded " + this.name));
    }

    public int getMotionTimeMillis() {
        return this.motionTimeMillis;
    }

    public void setMotionTimeMillis(int motionTimeMillis) {
        this.motionTimeMillis = motionTimeMillis;
    }

    public State getState() {
        return this.state;
    }

    @Guarded
    public synchronized void open() {
        if (this.state != State.CLOSE) {
            log.error((Object)"Trying to open while not CLOSE");
            throw new RuntimeException("Trying to open while not CLOSE");
        }
        this.moveTo(State.OPEN);
    }

    @Guarded
    public synchronized void close() {
        if (this.state != State.OPEN) {
            log.error((Object)"Trying to close while not OPEN");
            throw new RuntimeException("Trying to close while not OPEN");
        }
        this.moveTo(State.CLOSE);
    }

    protected synchronized void moveTo(final State target) {
        this.state = State.MOVING;
        log.fine((Object)("GuardedActuator " + this.name + " MOVING"));
        final String actName = this.name;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(GuardedActuatorForT.this.motionTimeMillis);
                }
                catch (InterruptedException e) {
                    log.warn((Object)"interrupted sleep", (Throwable)e);
                }
                GuardedActuatorForT guardedActuatorForT = GuardedActuatorForT.this;
                synchronized (guardedActuatorForT) {
                    GuardedActuatorForT.this.state = target;
                    log.fine((Object)("GuardedActuator " + actName + " " + (Object)((Object)target)));
                }
            }
        };
        new Thread(r).start();
    }

    static enum State {
        OPEN,
        CLOSE,
        MOVING;

    }
}

