/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.lsst.ccs.CurrentCommandContext;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.CCSVersions;
import org.lsst.ccs.bus.data.DistributionInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.RuntimeInfo;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.AlarmOnStateChange;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRuntimeInfo;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.LogBusHandler;
import org.lsst.ccs.utilities.logging.Log4JConfiguration;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;
import org.lsst.ccs.utilities.tracers.Names;

public class Agent
implements CommandExecutor {
    @Deprecated
    public static final ThreadLocal<CurrentCommandContext> LOCAL_EXECUTION_INFO;
    private final AgentInfo agentInfo;
    private final AtomicBoolean isAlive = new AtomicBoolean(true);
    protected static final Logger log;
    protected static final Logger subsystem_log;
    private volatile AgentMessagingLayer messagingAccess;
    private static volatile AgentMessagingLayer environmentAgentMessagingLayer;
    protected LogBusHandler logBusHandler;
    private final Scheduler scheduler;
    protected final Object commandExecutorLock = new Object();
    private final ExecutorService queryExecutor;
    protected final Set<RunningCommand> currentQueries;
    private final ExecutorService actionExecutor;
    protected volatile RunningCommand currentAction;
    private final ExecutorService signalExecutor;
    protected final Set<RunningCommand> currentSignals;
    private final ThreadGroup commandGroup = new ThreadGroup("Command Threads");
    private final ConcurrentHashMap<String, CommandSet> commandSetMap = new ConcurrentHashMap();
    private StateBundle innerState = new StateBundle(new Enum[0]);
    protected final Object innerStateLock = new Object();
    protected final PeriodicTask heartbeatPublisher;
    protected final PeriodicTask runtimeInfoPublisher;

    static {
        Log4JConfiguration.initialize();
        LOCAL_EXECUTION_INFO = new ThreadLocal();
        log = Logger.getLogger((String)"org.lsst.ccs");
        subsystem_log = Logger.getLogger((String)"org.lsst.ccs.subsystem");
        environmentAgentMessagingLayer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent(String name, AgentInfo.AgentType agentType) {
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_", "BUILD"));
        switch (agentType) {
            case LISTENER: 
            case CONSOLE: {
                name = Names.almostUniqueAgentName((String)name);
                break;
            }
        }
        this.agentInfo = new AgentInfo(name, AgentInfo.AgentType.valueOf((String)agentType.name()));
        this.scheduler = new Scheduler("Scheduler for " + name, 3);
        this.scheduler.setLogger(log);
        this.queryExecutor = Executors.newCachedThreadPool(this.createThreadFactory("CommandExecutor (QUERY)"));
        this.currentQueries = ConcurrentHashMap.newKeySet(3);
        this.actionExecutor = Executors.newSingleThreadExecutor(this.createThreadFactory("CommandExecutor (ACTION)"));
        this.signalExecutor = Executors.newCachedThreadPool(this.createThreadFactory("CommandExecutor (SIGNAL)"));
        this.currentSignals = ConcurrentHashMap.newKeySet(3);
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + name, "BUS CONNECTIONS"));
        long heartbeatPeriod = this.agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.valueOf((String)AgentInfo.AgentType.WORKER.name())) >= 0 ? 1 : 5;
        this.heartbeatPublisher = new PeriodicTask(this.scheduler, () -> {
            LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.getName(), "STATUS BROADCASTING"));
            this.broadcastStatus();
        }, true, "heartbeat", Level.SEVERE, heartbeatPeriod, TimeUnit.SECONDS);
        this.runtimeInfoPublisher = this.agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.valueOf((String)AgentInfo.AgentType.WORKER.name())) >= 0 ? new PeriodicTask(this.scheduler, () -> {
            RuntimeInfo runtimeInfo = new RuntimeInfo();
            StatusRuntimeInfo message = new StatusRuntimeInfo(runtimeInfo, this.getState());
            this.messagingAccess.sendStatusMessage((StatusMessage)message);
        }, true, "runtimeInfo", Level.SEVERE, 1L, TimeUnit.MINUTES) : null;
        Object object = this.innerStateLock;
        synchronized (object) {
            this.innerState.setState(new Enum[]{CommandState.READY, OperationalState.ENGINEERING_OK, AlertState.NOMINAL});
        }
        if (!BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.startInEngineeringMode", "").isEmpty() || !System.getProperty("org.lsst.ccs.startInEngineeringMode", "").isEmpty()) {
            System.out.println("INFO: Property \"org.lsst.ccs.startInEngineeringMode\" has been deprecated and has no effect. Please remove it from your resource properties or java code.");
        }
    }

    public void start() {
        this.addCommandSet("", new CommandSetBuilder().buildCommandSet((Object)this));
        this.connectToTheBuses();
        this.getMessagingAccess().setCommandExecutor((CommandExecutor)this);
        this.updateInternalState("Starting the subsystem", new AgentState[]{PhaseState.INITIALIZING, CommandState.READY, OperationalState.ENGINEERING_OK, AlertState.NOMINAL});
        this.heartbeatPublisher.start();
        if (this.runtimeInfoPublisher != null) {
            this.runtimeInfoPublisher.start();
        }
        LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.getName(), "INITIALIZATION"));
        boolean startupOk = this.internalStart();
        if (startupOk) {
            this.updateInternalState(null, new AgentState[]{PhaseState.OPERATIONAL});
        }
    }

    private void terminate() {
        if (this.isAlive.getAndSet(false)) {
            LOCAL_EXECUTION_INFO.set(new CurrentCommandContext("_SUBSYSTEM_" + this.getName(), "END PHASE"));
            log.fine((Object)("Subsystem " + this.getName() + " final shutdown"));
            if (this.logBusHandler != null) {
                this.logBusHandler.close();
            }
            this.scheduler.shutdownNow();
            this.queryExecutor.shutdownNow();
            this.actionExecutor.shutdownNow();
            this.signalExecutor.shutdownNow();
            this.messagingAccess.shutdownBusAccess();
        }
    }

    @Command(description="shutdown", type=Command.CommandType.ACTION)
    public final Object shutdown() throws Exception {
        log.fine((Object)(String.valueOf(this.getName()) + " is shutting down"));
        this.updateInternalState(null, new AgentState[]{PhaseState.CLOSING});
        this.internalShutdown();
        this.updateInternalState(null, new AgentState[]{PhaseState.OFF_LINE});
        if (Thread.currentThread().getThreadGroup() != this.commandGroup) {
            this.terminate();
        }
        return "OK";
    }

    @Deprecated
    protected boolean startAgent() {
        return this.internalStart();
    }

    protected boolean internalStart() {
        return true;
    }

    @Deprecated
    protected void shutdownAgent() throws Exception {
        this.internalShutdown();
    }

    protected void internalShutdown() throws Exception {
    }

    public final String getName() {
        return this.agentInfo.getName();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public int getCommandCount(Command.CommandType ... types) {
        if (types.length == 0) {
            return this.currentQueries.size() + (this.currentAction == null ? 0 : 1) + this.currentSignals.size();
        }
        int out = 0;
        Command.CommandType[] commandTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Command.CommandType type = commandTypeArray[n2];
            out += this.getCommandCount(type);
            ++n2;
        }
        return out;
    }

    public int getStatusBroadcastPeriod() {
        return (int)this.heartbeatPublisher.getPeriod(TimeUnit.SECONDS);
    }

    @Command(description="is the system in engineering mode ?", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public boolean isInEngineeringMode() {
        Enum em = this.getState(OperationalState.class);
        return em != null && em.compareTo(OperationalState.ENGINEERING_OK) >= 0;
    }

    @Command(description="Get the CCS Versions for the current CCS Environment", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public CCSVersions getCCSVersions() {
        CCSVersions ccsVersions = new CCSVersions();
        List agents = this.getMessagingAccess().getAgentPresenceManager().listConnectedAgents();
        ConcurrentMessagingUtils concurrentMessagingUtils = new ConcurrentMessagingUtils(this.getMessagingAccess());
        for (AgentInfo a : agents) {
            CommandRequest request = new CommandRequest(a.getName(), "getDistributionInfo");
            try {
                Object distInfo = concurrentMessagingUtils.sendSynchronousCommand(request, 1000L);
                if (distInfo == null) continue;
                ccsVersions.add((org.lsst.ccs.bus.messages.AgentInfo)a, (org.lsst.ccs.bus.messages.DistributionInfo)((DistributionInfo)distInfo));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ccsVersions.add((org.lsst.ccs.bus.messages.AgentInfo)this.getAgentInfo(), (org.lsst.ccs.bus.messages.DistributionInfo)new DistributionInfo());
        return ccsVersions;
    }

    @Command(description="Get the Agent's DistributionInfo object.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public DistributionInfo getDistributionInfo() {
        return new DistributionInfo();
    }

    @Command(description="get the command dictionary for the subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    @Deprecated
    public HashMap<String, Dictionary> getSystemDictionary() {
        return this.getDictionaries();
    }

    @Command(description="get the command dictionary for the subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public HashMap<String, Dictionary> getDictionaries() {
        HashMap<String, Dictionary> dictionaries = new HashMap<String, Dictionary>(this.commandSetMap.size() * 2);
        this.commandSetMap.forEach((name, commandSet) -> {
            Dictionary dictionary = dictionaries.put((String)name, commandSet.getCommandDictionary());
        });
        return dictionaries;
    }

    protected CommandSet getCommandSet(String name) {
        if (this.commandSetMap.containsKey(name)) {
            return this.commandSetMap.get(name);
        }
        String componentName = name.substring(name.lastIndexOf("/"));
        for (String path : this.commandSetMap.keySet()) {
            if (!path.endsWith(componentName)) continue;
            return this.commandSetMap.get(path);
        }
        return null;
    }

    public void addCommandSet(String name, CommandSet commandSet) {
        String tmpName = this.getName();
        if (name.isEmpty() || name.equals("main")) {
            name = tmpName;
            CompositeCommandSet cmdSet = (CompositeCommandSet)this.commandSetMap.getOrDefault(name, (CommandSet)new CompositeCommandSet());
            cmdSet.add(commandSet);
            commandSet = cmdSet;
        } else {
            name = String.valueOf(tmpName) + "/" + name.replace("main/", "");
        }
        this.commandSetMap.put(name, commandSet);
    }

    public AgentMessagingLayer getMessagingAccess() {
        if (this.messagingAccess == null) {
            this.connectToTheBuses();
        }
        return this.messagingAccess;
    }

    private void setEnvironmentMessagingAccess(AgentMessagingLayer layer) {
        if (environmentAgentMessagingLayer == null) {
            environmentAgentMessagingLayer = layer;
        } else if (BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false").equals("false")) {
            throw new RuntimeException("*** Should not have two agents running in same JVM");
        }
    }

    public static AgentMessagingLayer getEnvironmentMessagingAccess() {
        if (environmentAgentMessagingLayer == null) {
            throw new IllegalStateException("The environment has not been initialized yet");
        }
        return environmentAgentMessagingLayer;
    }

    private synchronized void connectToTheBuses() {
        if (this.messagingAccess == null) {
            this.messagingAccess = AgentMessagingLayer.createInstance((AgentInfo)this.agentInfo);
            this.setEnvironmentMessagingAccess(this.messagingAccess);
            this.initLogBusHandler();
        }
    }

    private void initLogBusHandler() {
        if (this.logBusHandler == null) {
            java.util.logging.Logger generalLogger = java.util.logging.Logger.getLogger("org.lsst.ccs");
            this.logBusHandler = new LogBusHandler(this.messagingAccess);
            generalLogger.addHandler((Handler)this.logBusHandler);
        }
    }

    @Deprecated
    public boolean isAgentInState(Enum state) {
        return this.isInState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInState(Enum state) {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.isInState(state);
        }
    }

    @Deprecated
    public boolean isAgentInState(StateBundle state) {
        return this.isInState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInState(StateBundle state) {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.isInState(state);
        }
    }

    @Deprecated
    public Enum getAgentState(Class stateClass) {
        return this.getState(stateClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enum getState(Class stateClass) {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.getState(stateClass);
        }
    }

    @Deprecated
    public StateBundle getAgentState() {
        return this.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateBundle getState() {
        Object object = this.innerStateLock;
        synchronized (object) {
            return this.innerState.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAgentState(String extraInfo, Enum ... stateChanges) {
        StateBundle after;
        StateBundle before;
        Enum[] enumArray = stateChanges;
        int n = stateChanges.length;
        int n2 = 0;
        while (n2 < n) {
            Enum state = enumArray[n2];
            if (state instanceof AgentState) {
                throw new IllegalArgumentException("Attempt to modify internal Agent states");
            }
            ++n2;
        }
        Object object = this.innerStateLock;
        synchronized (object) {
            before = this.innerState.clone();
            Enum[] enumArray2 = stateChanges;
            int n3 = stateChanges.length;
            int n4 = 0;
            while (n4 < n3) {
                Enum state = enumArray2[n4];
                this.innerState.setState(state);
                ++n4;
            }
            after = this.innerState.clone();
        }
        this.publishStateChange(extraInfo, before, after);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateInternalState(String extraInfo, AgentState ... stateChanges) {
        StateBundle after;
        StateBundle before;
        Object object = this.innerStateLock;
        synchronized (object) {
            before = this.innerState.clone();
            AgentState[] agentStateArray = stateChanges;
            int n = stateChanges.length;
            int n2 = 0;
            while (n2 < n) {
                AgentState state = agentStateArray[n2];
                this.innerState.setState((Enum)state);
                ++n2;
            }
            after = this.innerState.clone();
            if (!AgentState.isLegal((StateBundle)before, (StateBundle)after)) {
                this.innerState = before;
                throw new IllegalArgumentException("Illegal state transition from " + before + " to " + after);
            }
        }
        this.publishStateChange(extraInfo, before, after);
    }

    protected void publishStateChange(String extraInfo, StateBundle before, StateBundle after) {
        StatusStateChangeNotification sm = new StatusStateChangeNotification(before, after);
        this.getMessagingAccess().sendStatusMessage((StatusMessage)sm);
        Enum alarm = after.getState(AlertState.class);
        if (alarm != null && alarm.compareTo(AlertState.WARNING) >= 0) {
            AlarmOnStateChange alarmOnStateChange = new AlarmOnStateChange(before, after, extraInfo);
            this.getMessagingAccess().sendStatusMessage((StatusMessage)alarmOnStateChange);
        }
    }

    public final void publishSubsystemDataOnStatusBus(KeyValueData keyValueData) {
        StatusSubsystemData message = new StatusSubsystemData((Serializable)keyValueData, this.getState());
        this.messagingAccess.sendStatusMessage((StatusMessage)message);
    }

    @Deprecated
    protected StatusMessage fillStatus(StatusMessage statusMessage) {
        statusMessage.setState(this.getState());
        return statusMessage;
    }

    @Deprecated
    public void setStatusBroadcastPeriod(int statusBroadcastPeriod) {
        this.heartbeatPublisher.setPeriod((long)statusBroadcastPeriod, TimeUnit.SECONDS);
        this.heartbeatPublisher.start();
    }

    protected final void broadcastStatus() {
        StatusHeartBeat s = new StatusHeartBeat(this.getStatusBroadcastPeriod(), this.getState());
        this.updateHeartBeat(s);
        this.messagingAccess.sendStatusMessage((StatusMessage)s);
    }

    @Deprecated
    protected void startStatusBroadcasting() {
        this.heartbeatPublisher.start();
    }

    @Deprecated
    protected void stopStatusBroadcasting() {
        this.heartbeatPublisher.cancel(false);
    }

    protected void updateHeartBeat(StatusHeartBeat heartBeat) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommandRequest(CommandRequest request) {
        Object object = this.commandExecutorLock;
        synchronized (object) {
            try {
                boolean notTopCommand;
                subsystem_log.info((Object)("Received command request from " + request.getOriginAgentInfo().getName() + ": " + request.getBasicCommand()));
                PhaseState phase = (PhaseState)this.getState(PhaseState.class);
                if (phase == null || phase == PhaseState.OFF_LINE) {
                    CommandNack nack = new CommandNack(request, (Serializable)((Object)"Cannot accept command: OFF_LINE or NULL phase state"));
                    log.debug((Object)("sending nack " + nack));
                    this.messagingAccess.sendCommandReply((CommandReply)nack);
                    return;
                }
                String destination = request.getDestination();
                boolean bl = notTopCommand = destination.contains("/") && !destination.endsWith("/main");
                if (notTopCommand && this.getState(OperationalState.class).compareTo(OperationalState.ENGINEERING_OK) < 0) {
                    CommandNack nack = new CommandNack(request, (Serializable)((Object)"can't access lower level component (not named \"main\") if not in ENGINEERING MODE"));
                    log.debug((Object)("sending nack " + nack));
                    this.messagingAccess.sendCommandReply((CommandReply)nack);
                    return;
                }
                BasicCommand basicCommand = request.getBasicCommand();
                CommandSet commandSet = this.getCommandSet(destination);
                if (commandSet == null) {
                    throw new RuntimeException("Unknown destination " + destination);
                }
                DictionaryCommand dictionaryCommand = commandSet.getCommandDictionary().findCommand(basicCommand);
                if (dictionaryCommand == null) {
                    throw new RuntimeException("Could not find command " + basicCommand);
                }
                Command.CommandType type = dictionaryCommand.getType();
                switch (type) {
                    case QUERY: {
                        RunningCommand runningCommand = this.acceptCommand(request, type, commandSet);
                        this.currentQueries.add(runningCommand);
                        this.queryExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    case CONFIGURATION: {
                        if (this.getState(OperationalState.class).compareTo(OperationalState.ENGINEERING_OK) < 0) {
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"CONFIGURATION commands are only accepted in ENGINEERING mode"));
                            log.debug((Object)("sending nack " + nack));
                            this.messagingAccess.sendCommandReply((CommandReply)nack);
                            return;
                        }
                    }
                    case ACTION: {
                        RunningCommand runningCommand;
                        if (!this.isInState((Enum)CommandState.READY)) {
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"ACTION and CONFIGURATION commands are only accepted in READY state"));
                            log.debug((Object)(type + " sending nack " + nack));
                            this.messagingAccess.sendCommandReply((CommandReply)nack);
                            return;
                        }
                        this.updateInternalState(null, new AgentState[]{CommandState.ACTIVE});
                        this.currentAction = runningCommand = this.acceptCommand(request, type, commandSet);
                        this.actionExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    case SIGNAL: 
                    case ABORT: {
                        long dueTime;
                        long currentTime = dueTime = System.currentTimeMillis();
                        DictionaryArgument[] arguments = dictionaryCommand.getArguments();
                        if (arguments.length > 0 && "Long".equalsIgnoreCase(arguments[0].getSimpleType())) {
                            String argAsString = String.valueOf(basicCommand.getArguments()[0]);
                            Long expectedMaxDelay = new Long(argAsString);
                            dueTime = currentTime + expectedMaxDelay;
                        }
                        for (RunningCommand rc : this.currentSignals) {
                            if (rc.timeout >= dueTime) continue;
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"SIGNAL with shorter deadline is already running"));
                            log.debug((Object)(type + " sending nack " + nack));
                            this.messagingAccess.sendCommandReply((CommandReply)nack);
                            return;
                        }
                        this.updateInternalState(null, new AgentState[]{CommandState.ACTIVE});
                        log.fine((Object)("Received Signal from " + request.getOriginAgentInfo().getName() + " for running action " + this.currentAction));
                        RunningCommand runningCommand = this.acceptCommand(request, type, commandSet);
                        this.currentSignals.add(runningCommand);
                        this.signalExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    default: {
                        assert (false) : "Unknown command type :" + type;
                    }
                }
            }
            catch (Throwable t) {
                CommandNack nack = new CommandNack(request, (Serializable)t);
                log.error((Object)"Error processing command request ", t);
                this.messagingAccess.sendCommandReply((CommandReply)nack);
            }
        }
    }

    private RunningCommand acceptCommand(CommandRequest request, Command.CommandType type, CommandSet commandSet) {
        CommandAck ack = new CommandAck(request);
        log.debug((Object)(type + " sending ack " + ack));
        this.messagingAccess.sendCommandReply((CommandReply)ack);
        return new RunningCommand(request, type, commandSet);
    }

    private ThreadFactory createThreadFactory(String name) {
        return run -> {
            Thread thread = new Thread(this.commandGroup, run, name);
            thread.setUncaughtExceptionHandler((t, x) -> log.error((Object)("Uncaught exception in command thread " + t.getName()), x));
            return thread;
        };
    }

    public RunningCommand getCurrentAction() {
        return this.currentAction;
    }

    private int getCommandCount(Command.CommandType type) {
        switch (type) {
            case QUERY: {
                return this.currentQueries.size();
            }
            case ACTION: 
            case CONFIGURATION: {
                RunningCommand current = this.currentAction;
                if (current.type == null) {
                    return 0;
                }
                return current.type == type ? 1 : 0;
            }
            case SIGNAL: {
                return this.currentSignals.size();
            }
        }
        assert (false) : "Unknown command type " + type;
        return 0;
    }

    static /* synthetic */ void access$1(Agent agent) {
        agent.terminate();
    }

    public class RunningCommand {
        protected final CommandRequest request;
        protected final Command.CommandType type;
        protected final CommandSet commandSet;
        protected final long timeout;
        protected Serializable result;

        RunningCommand(CommandRequest request, Command.CommandType type, CommandSet commandSet) {
            this(request, type, commandSet, 0L);
        }

        RunningCommand(CommandRequest request, Command.CommandType type, CommandSet commandSet, long timeout) {
            this.request = request;
            this.type = type;
            this.commandSet = commandSet;
            this.timeout = timeout;
        }

        FutureTask<Object> getTask() {
            return new FutureTask<Object>(() -> {
                BasicCommand basicCommand = this.request.getBasicCommand();
                LOCAL_EXECUTION_INFO.set(new CurrentCommandContext(this.request.getOriginAgentInfo().getName(), basicCommand.getCommand(), this.type, basicCommand.getArguments()));
                try {
                    this.result = (Serializable)this.commandSet.invoke(basicCommand);
                }
                catch (Throwable t) {
                    log.debug((Object)("Command execution error:" + basicCommand.getCommand() + Arrays.toString(basicCommand.getArguments())), t);
                    this.result = t;
                }
                CommandResult reply = new CommandResult(this.request, this.result);
                log.debug((Object)(this.type + " reply will be sent:  " + reply));
                Object object = Agent.this.commandExecutorLock;
                synchronized (object) {
                    switch (this.type) {
                        case QUERY: {
                            Agent.this.currentQueries.remove(this);
                            break;
                        }
                        case ACTION: 
                        case CONFIGURATION: {
                            Agent.this.currentAction = null;
                            if (!Agent.this.currentSignals.isEmpty()) break;
                            Agent.this.updateInternalState(null, new AgentState[]{CommandState.READY});
                            break;
                        }
                        case SIGNAL: {
                            Agent.this.currentSignals.remove(this);
                            if (Agent.this.currentAction != null || !Agent.this.currentSignals.isEmpty()) break;
                            Agent.this.updateInternalState(null, new AgentState[]{CommandState.READY});
                            break;
                        }
                        default: {
                            assert (false) : "Unknown command type :" + this.type;
                            break;
                        }
                    }
                }
                Agent.this.messagingAccess.sendCommandReply((CommandReply)reply);
                if (Agent.this.isInState((Enum)PhaseState.OFF_LINE) && Agent.this.currentAction == null && Agent.this.currentSignals.isEmpty()) {
                    Thread shutdownThread = new Thread(() -> Agent.access$1(Agent.this), "Agent shutdown thread");
                    shutdownThread.start();
                }
                LOCAL_EXECUTION_INFO.set(null);
                return this.result;
            });
        }

        public String toString() {
            return "Command(" + this.type.name() + ") from " + this.request.getOriginAgentInfo().getName() + ": " + this.request.getBasicCommand().toString();
        }
    }
}

